package org.tizen.common.util;

import static org.junit.Assert.*;

import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import org.junit.Test;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.Template;

import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;
import static org.mockito.Mockito.verify;


/*
 * Common
 *
 * Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact: 
 * BonYong Lee <bonyong.lee@samsung.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
 *
 */
public class FreeMarkerUtilTest {
    
    /**
     * Test {@link FreeMarkerUtil#getDefaultConfiguration()}
     * 
     * @throws Exception in case of failure in test
     * 
     * @see FreeMarkerUtil#getDefaultConfiguration()
     */
    @Test
    public void test_getDefaultConfiguration() throws Exception {
        Configuration defaultConfiguration = FreeMarkerUtil.getDefaultConfiguration();
        
        String encoding = defaultConfiguration.getEncoding(Locale.getDefault());
        assertTrue(encoding.equals("8859_1"));
        
        assertTrue(defaultConfiguration.getObjectWrapper() instanceof DefaultObjectWrapper);
    }
    
    /**
     * Test {@link FreeMarkerUtil#generateDocument(Map, Configuration, String, Writer)}
     * 
     * @throws Exception in case of failure in test
     * 
     * @see FreeMarkerUtil#generateDocument(Map, Configuration, String, Writer)
     */
    @Test
    public void test_generateDocument() throws Exception {
        final String templateFile = "zz";
        final Map<String, Object> root = new HashMap<String, Object>();
        final Writer mockWriter = mock( Writer.class );
        
        final Configuration mockCfg = mock (Configuration.class);
        final Template mockTemplate = mock( Template.class );
        when(mockCfg.getTemplate(templateFile)).thenReturn(mockTemplate);
        
        FreeMarkerUtil.generateDocument(root, mockCfg, templateFile, mockWriter);
        verify(mockCfg).getTemplate(templateFile);
        verify(mockTemplate).process(root, mockWriter);
    }
}
