/*
 *  Common
 *
 * Copyright (c) 2000 - 2012 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact: 
 * BonYong Lee <bonyong.lee@samsung.com>
 * TaeYoung son <taeyoung2.son@samsung.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
 *
 */
package org.tizen.common.util;

import static org.junit.Assert.assertEquals;

import org.junit.Test;

/**
 * ObjectUtilTest.
 * 
 * Test case  for {@link ObjectUtil}
 * 
 * @author BonYong Lee{@literal <bonyong.lee@samsung.com>} (S-Core)
 * @author TaeYoung Son{@literal <taeyoung2.son@samsung.com>} (S-Core)
 * 
 * @see ObjectUtil
 */
public class
ObjectUtilTest
{
    /**
     * Test for {@link ObjectUtil#nvl(Object...)}
     * 
     * @throws Exception If test fails
     */
    @Test
    public
    void
    test_nvl()
    {
        final Object[][] TEST_CASES = new Object[][] {
                new Object[] { null, null },
                new Object[] { new Object[] { null }, null },
                new Object[] { new Object[] { "hello" }, "hello" },
                new Object[] { new Object[] { null, null, "b" }, "b" },
                new Object[] { new Object[] { null, "a", "b" }, "a" } };

        int nTestCase = 0;
        for (final Object[] TEST_CASE : TEST_CASES) {
            nTestCase++;
            final Object[] input = (Object[]) TEST_CASE[0];
            final Object expected = TEST_CASE[1];

            assertEquals(nTestCase + "th test case failed." + "\n input : "
                    + input.toString() + "\n", expected, ObjectUtil.nvl(input));
        }
    }

    /**
     * Test for {@link ObjectUtil#equals(Object, Object)}
     * 
     * @throws Exception If test fails
     */
    @Test
    public
    void
    test_equals()
    {
        final Object[][] TEST_CASES = new Object[][] {
                new Object[] { null, null, true },
                new Object[] { null, "a", false },
                new Object[] { "a", null, false },
                new Object[] { "a", "a", true },
                new Object[] { "a", new String("a"), true },
                new Object[] { "a", "b", false },
                new Object[] { new char[] { 'a', 'a', 'b' },
                        new char[] { 'a', 'a', 'b' }, true },
                new Object[] { new int[] { 1, 2, 3 }, new int[] { 1, 3, 2 },
                        false } };

        int nTestCase = 0;
        for (final Object[] TEST_CASE : TEST_CASES)
        {
            nTestCase++;
            final Object input1 = (Object) TEST_CASE[0];
            final Object input2 = (Object) TEST_CASE[1];
            final Object expected = TEST_CASE[2];
            assertEquals(nTestCase + "th test case failed."
                    + "\n first input : " + input1 + "\n" + "second input : "
                    + input2 + "\n", expected,
                    ObjectUtil.equals(input1, input2));
        }
    }

    /**
     * Test for {@link ObjectUtil#hexFormat(int, int)}
     * 
     * @throws Exception If test fails
     */
    @Test
    public
    void
    test_hexFormat()
    {
        final Object[][] TEST_CASES = new Object[][] {
                new Object[] { 0, 0, "" },
                new Object[] { 0, 2, "00" },
                new Object[] { 15, 1, "f" },
                new Object[] { 15, 3, "00f" },
                new Object[] { 2147483647, 10, "007fffffff" },
                new Object[] { -2147483647, 10, "0080000001" },
                new Object[] { -1, 1, "f" }
        };

        int nTestCase = 0;
        for ( final Object[] TEST_CASE : TEST_CASES )
        {
            nTestCase++;
            final Object input1 = TEST_CASE[0];
            final Object input2 = TEST_CASE[1];
            final Object expected = TEST_CASE[2];

            assertEquals(nTestCase + "th test case failed."
                    + "\n first input : " + input1.toString() + "\n" + "second input : "
                    + input2.toString() + "\n", (String)expected,
                    ObjectUtil.hexFormat((Integer)input1, ((Integer)input2).intValue()));
        }

    }

    /**
     * Test for {@link ObjectUtil#toString(Object)}
     * 
     * @throws Exception If test fails
     */
    @Test
    public
    void
    test_toString()
    {
        final Object[][] TEST_CASES = new Object[][] {
                new Object[] { null, "<<null>>" },
                new Object[] { "null", "String@C587" },
                new Object[] { "a", "String@0061" },
                new Object[] { "A", "String@0041" },
                new Object[] { 1, "Integer@0001" },
                new Object[] { 10, "Integer@000A" },
                new Object[] { -1, "Integer@FFFF" },
                };

        int nTestCase = 0;
        for (final Object[] TEST_CASE : TEST_CASES) {
            nTestCase++;
            final Object input = TEST_CASE[0];
            final Object expected = TEST_CASE[1];

            assertEquals(nTestCase + "th test case failed." + "\n input : "
                    + input + "\n", expected, ObjectUtil.toString(input));
        }
    }
}
