/*
 *  Common
 *
 * Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact: 
 * BonYong Lee <bonyong.lee@samsung.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
 *
 */
package org.tizen.common.util;

import static org.junit.Assert.assertEquals;

import org.junit.Test;


/**
 * ParsingUtilTest
 *
 * Test case for {@link ParsingUtil}
 * 
 * @author BonYong Lee{@literal <bonyong.lee@samsung.com>} (S-Core)
 * 
 * @see ParsingUtil
 */
public class ParsingUtilTest
{
    /**
     * Test {@link ParsingUtil#parseBoolean(String, boolean)}
     * 
     * @throws Exception in case of failure in test
     * 
     * @see ParsingUtil#parseBoolean(String, boolean)
     */
	@Test
	public void test_parseBoolean() throws Exception
	{
		assertEquals( true, ParsingUtil.parseBoolean( "true", false ) );
		assertEquals( false, ParsingUtil.parseBoolean( null, false ) );
		assertEquals( true, ParsingUtil.parseBoolean( null, true ) );
		assertEquals( false, ParsingUtil.parseBoolean( "xxxx", false ) );
		assertEquals( true, ParsingUtil.parseBoolean( "xxxx", true ) );
		assertEquals( true, ParsingUtil.parseBoolean( "Y", false ) );
		assertEquals( true, ParsingUtil.parseBoolean( "1", false ) );
	}
	
    /**
     * Test {@link ParsingUtil#parseInt(String, int)}
     * 
     * @throws Exception in case of failure in test
     * 
     * @see ParsingUtil#parseInt(String, int)
     */
	@Test
	public void test_parseInt() throws Exception
	{
		assertEquals( 3, ParsingUtil.parseInt( "3", 0 ) );
		assertEquals( 2, ParsingUtil.parseInt( "2", 0 ) );
		assertEquals( 16, ParsingUtil.parseInt( "0x10", 0 ) );
		assertEquals( 8, ParsingUtil.parseInt( "010", 0 ) );
	}

    /**
     * Test {@link ParsingUtil#parseLong(String, long)}
     * 
     * @throws Exception in case of failure in test
     * 
     * @see ParsingUtil#parseLong(String, long)
     */
	@Test
	public void test_parseLong() throws Exception
	{
		assertEquals( 3, ParsingUtil.parseLong( "3", 0 ) );
		assertEquals( 2, ParsingUtil.parseLong( "2", 0 ) );
		assertEquals( 16, ParsingUtil.parseLong( "0x10", 0 ) );
		assertEquals( 8, ParsingUtil.parseLong( "010", 0 ) );
	}

    /**
     * Test {@link ParsingUtil#parseDouble(String, double)}
     * 
     * @throws Exception in case of failure in test
     * 
     * @see ParsingUtil#parseDouble(String, double)
     */
	@Test
	public void test_parseDouble() throws Exception
	{
		assertEquals( 3.0, ParsingUtil.parseDouble( "3", 0 ), 0 );
		assertEquals( 2.0, ParsingUtil.parseDouble( "2", 0 ), 0 );
	}

}
