package org.tizen.common.util;

import static org.mockito.Mockito.mock;
import static org.junit.Assert.*;

import org.eclipse.core.resources.IProject;
import org.junit.Test;
import org.tizen.common.core.application.ProfileInfo;

public class ProjectUtilTest {

    @Test
    public void testCreateTizenProjectDescription() {
        IProject mockProject = mock( IProject.class );
        ProfileInfo mockProfileInfo = mock( ProfileInfo.class ); 
        
        Object[][] TEST_CASES = {
                // IProject, ProfileInfo, expectedResult( Boolean or exception class )
                { null, null, IllegalArgumentException.class },
                { null, mockProfileInfo, IllegalArgumentException.class },
                { mockProject, null, IllegalArgumentException.class },
                // Because Eclipse registry is used, skip cases
            };
        
        for (Object[] TEST_CASE : TEST_CASES ) {
            IProject project = (IProject) TEST_CASE[0];
            ProfileInfo profile = (ProfileInfo) TEST_CASE[1];
            Object expectedResult = TEST_CASE[2];
            
            if ( expectedResult.getClass().equals( Boolean.class ) ) {
                assertTrue( ProjectUtil.createTizenProjectDescription( project, profile ) == ( (Boolean) expectedResult ) );
            } else {
                try {
                    ProjectUtil.createTizenProjectDescription( project, profile );
                    fail();
                } catch( Exception e ) {
                    assertTrue( e.getClass().equals( expectedResult ) );
                }
            }
        }
    }
    
    @Test
    public void testUpdateTizenProjectDescription() {
        IProject mockProject = mock( IProject.class );
        ProfileInfo mockProfileInfo = mock( ProfileInfo.class ); 
        
        Object[][] TEST_CASES = {
                // IProject, ProfileInfo, expectedResult( Boolean or exception class )
                { null, null, IllegalArgumentException.class },
                { null, mockProfileInfo, IllegalArgumentException.class },
                { mockProject, null, IllegalArgumentException.class },
                // Because Eclipse registry is used, skip cases
            };
        
        for (Object[] TEST_CASE : TEST_CASES ) {
            IProject project = (IProject) TEST_CASE[0];
            ProfileInfo profile = (ProfileInfo) TEST_CASE[1];
            Object expectedResult = TEST_CASE[2];
            
            if ( expectedResult.getClass().equals( Boolean.class ) ) {
                assertTrue( ProjectUtil.updateTizenProjectDescription( project, profile ) == ( (Boolean) expectedResult ) );
            } else {
                try {
                    ProjectUtil.updateTizenProjectDescription( project, profile );
                    fail();
                } catch( Exception e ) {
                    assertTrue( e.getClass().equals( expectedResult ) );
                }
            }
        }
    }
}
