/*
*  Common
*
* Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
*
* Contact: 
* BonYong Lee <bonyong.lee@samsung.com>
* 
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
* Contributors:
* - S-Core Co., Ltd
*
*/
package org.tizen.common.util.url.classpath;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;

import org.junit.Test;

/**
 * ConnectionTest
 *
 * Test case for {@link Connection}
 * 
 * @author BonYong Lee{@literal <bonyong.lee@samsung.com>} (S-Core)
 * 
 * @see Connection
 */
public class ConnectionTest
{
	/**
	 * Test {@link Connection#getClassLoaders()
	 * 
	 * @throws Exception in case of failure in test
	 * 
	 * @see {@link Connection#getClassLoaders()
	 */
	@Test
	public
	void
	test_getClassLoaders()
	throws Exception
	{
	    Connection connection = new Connection( new URL( "file:///virtualurl" ), getClass().getName() );
		final Object[] classLoaders = connection.getClassLoaders().toArray();
		assertEquals( 1, classLoaders.length );
		
		URLClassLoader classLoader = new URLClassLoader( new URL[] {} );
		Thread.currentThread().setContextClassLoader( classLoader );
		
		final Object[] classLoaders2 = connection.getClassLoaders().toArray();
		assertEquals( classLoader, classLoaders2[0] );
		assertEquals( ClassLoader.getSystemClassLoader(), classLoaders2[1] );
	}
	
	/**
	 * Test {@link Connection#getInputStream()
	 * 
	 * @throws Exception in case of failure in test
	 * 
	 * @see Connection#getInputStream()
	 */
	@Test
	public void test_getInputStream() throws Exception
	{
		final Connection con = new Connection( new URL( "file:///virtualurl" ), null );
		try
		{
			con.getInputStream();
			fail( "Connection must throw IOException" );
		}
		catch ( final IOException e )
		{
		}
	}

}
