/*
*  Common
*
* Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
*
* Contact: 
* BonYong Lee <bonyong.lee@samsung.com>
* 
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
* Contributors:
* - S-Core Co., Ltd
*
*/
package org.tizen.common.util.url.cp;

import static org.junit.Assert.assertTrue;
import static org.tizen.common.util.IOUtil.tryClose;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;


/**
 * HandlerTest
 *
 * Test case for {@link Handler}
 * 
 * @author BonYong Lee{@literal <bonyong.lee@samsung.com>} (S-Core)
 * 
 * @see Handler
 */
public class
HandlerTest
{
	/**
	 * Property key for URL handler
	 */
	protected static final String PROP_PKG = "java.protocol.handler.pkgs";
	
	/**
	 * Old property value for URL handler
	 */
	protected String oldConfig;
	
	/**
	 * Set up URL handler before test
	 */
	@Before
	public void setUp()
	{
		oldConfig = System.getProperty( PROP_PKG );
		System.setProperty( PROP_PKG, "org.tizen.common.util.url" );
	}
	
	/**
	 * Restore URL handler after test
	 */
	@After
	public void tearDown()
	{
        if ( null == oldConfig )
        {
            System.clearProperty( "java.protocol.handler.pkgs" );
        }
        else
        {
            System.setProperty( "java.protocol.handler.pkgs", oldConfig );
        }
	}
	
	/**
	 * Test {@link Handler#openConnection(URL)
	 * 
	 * @throws Exception in case of failure in test
	 * 
	 * @see {@link Handler#openConnection(URL)
	 */
	@Test
	public void test_openConnection() throws Exception
	{
		
		final Handler handler = new Handler();
		final URL url = new URL( "cp:///" + getClass().getName().replace( '.', '/' ) + ".class" );
		
		final URLConnection connection = handler.openConnection( url );
		
		connection.connect();
		InputStream in = connection.getInputStream();
		try
		{
			assertTrue( 0 < in.read() );
		}
		finally
		{
			tryClose( in );
		}
		
		
	}

}
