/*
 * Common
 *
 * Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact: 
 * BonYong Lee <bonyong.lee@samsung.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
 *
 */
package org.tizen.common;


/**
 * IShell
 * 
 * Interface to parse and convert result
 *
 * @author BonYong Lee{@literal <bonyong.lee@samsung.com>} (S-Core)
 * 
 */
public interface
IShell
{
    /**
     * Terminate shell after delay and convert result to object of T
     * 
     * @param instance instance for result
     * @param delay
     * @return
     * 
     * @throws Exception
     */
    <T> T expect( final T instance, long delay) throws Exception;
    
    /**
     * Convert result to object of T
     * 
     * @param instance instance for result
     * @return result
     * 
     * @throws Exception If Can't convert result
     */
    <T> T expect( final T instance ) throws Exception;
    
    /**
     * Converts standard out or standard error to object of T
     * 
     * @param instance instance for result
     * @param standardError if true, converts standard error. Else, converts standard out
     * @return result
     * 
     * @throws Exception If Can't convert result
     */
    <T> T expect( final T instance, boolean standardError ) throws Exception;

    /**
     * Write data to the process shell executed
     * 
     * @param data data written to the process
     * @param delay time over which data written
     * @throws Exception
     */
    public void write( final String data, final long delay ) throws Exception;
    
}
