package org.tizen.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;

import org.tizen.sdblib.util.IOUtil;

public class LogConverter
{
    protected static final String PATTERN = "[{0}][PERFORM_E] {1}({2}) - [Category: {3}\tVariable: {4}] at {5} {6} \t [{7}(ms)]";

    protected static final MessageFormat FORMAT = new MessageFormat( PATTERN );
    
    protected class TestCase {
        protected String className;
        protected String name;
        protected String time;
        
        public TestCase(String className, String name, String time)
        {
            super();
            this.className = className;
            this.name = name;
            this.time = time;
        }



        @Override
        public String toString()
        {
            return "<testcase classname=\"" + className + "\" name=\"" + name + "\" time=\"" + time + "\" />";
        }
    }

    public static
    void
    main(
        final String[] args
    ) throws IOException
    {
        if ( args.length < 2 )
        {
            return ;
        }
        
        final File from = new File( args[0] );
        if ( !from.exists() || from.isDirectory() || !from.canRead() )
        {
            return ;
        }
        
        final File to = new File( args[1] );
        if ( from.isDirectory() || !from.canWrite() )
        {
            return ;
        }
        FileReader reader = null;
        FileWriter writer = null;
        try {
            reader = new FileReader( from );
            writer =  new FileWriter( to );
            final LogConverter instance = new LogConverter();
            instance.convert(reader ,writer);
        } finally {
            IOUtil.tryClose(reader, writer);
        }
    }
    
    protected
    String[]
    parse(
        final String line
    )
    {
        try
        {
            final Object[] args = FORMAT.parse( line );
            if ( args.length < 8 )
            {
                return null;
            }
            final String category = (String) args[3];
            final String variable = (String) args[4];
            final String time = (String) args[7];
            return new String[] { category, variable, time };
        }
        catch ( ParseException e )
        {
            return null;
        }
        
    }
    
    protected
    void
    convert(
        final Reader reader,
        final Writer writer
    )
    throws IOException
    {
        final BufferedReader lineReader = new BufferedReader( reader );
        String line = null;
        final ArrayList<TestCase> testCases = new ArrayList<TestCase>();
        long time = 0;
        while ( null != ( line = lineReader.readLine() ) )
        {
            final String[] args = parse( line );
            if ( null == args )
            {
                continue;
            }
            testCases.add( new TestCase( args[0], args[1], args[2] ) );
            try
            {
                time += Integer.parseInt( args[2] );
            }
            catch( final NumberFormatException e )
            {
            }
        }
        
        writer.append( "<testsuite errors=\"\" failures=\"\" name=\"IDE Performance\" skips=\"\" tests=\"" + testCases.size() + "\" time=\"" + time + "\">\n" );
        try
        {
            for ( final TestCase testCase : testCases )
            {
                writer.append( "\t" + testCase.toString() + "\n" );
            }
        }
        finally
        {
            writer.append( "</testsuite>" );
        }
        writer.flush();
    }
}
