/*
 * Common
 *
 * Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact: 
 * BonYong Lee <bonyong.lee@samsung.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
 *
 */
package org.tizen.common;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.text.MessageFormat;

/**
 * PatternValue
 *
 * Annotation to parse using pattern.
 * 
 * Pattern is for {@link MessageFormat}
 * 
 * @author BonYong Lee{@literal <bonyong.lee@samsung.com>} (S-Core)
 * 
 * @see Shell
 */
@Target( value = { ElementType.FIELD } )
@Retention( value = RetentionPolicy.RUNTIME )
public @interface
Pattern
{
    /**
     * pattern to use in parsing
     * @return pattern
     */
    String pattern();
    
    /**
     * argument index
     * 
     * @return index
     */
    int index();
    
    /**
     * Flag to trim. trim if value is {@value true}
     * @return flag
     */
    boolean trim() default true;

}
