/*
 *  Common
 *
 * Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact: 
 * BonYong Lee <bonyong.lee@samsung.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
 *
 */
package org.tizen.common.core.command;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.command.policy.PolicyRegistry;
import org.tizen.common.core.command.prompter.NopPrompter;
import org.tizen.common.file.VirtualFileHandler;

/**
 * CommandTest
 *
 * Test case for {@link Command}'s sub class
 * 
 * @author BonYong Lee{@literal <bonyong.lee@samsung.com>} (S-Core)
 */
public class
CommandTest
{
    
    /**
     * Logger for testcase
     */
    protected final Logger logger = LoggerFactory.getLogger( getClass() );
	/**
	 * {@link ExecutionContext} for test
	 */
	protected ExecutionContext context;
	
	/**
	 * {@link Executor} for test
	 */
	protected Executor executor;
	
	/**
	 * Return {@link Prompter} for test
	 * 
	 * @return {@link Prompter}
	 */
	protected
	Prompter
	getPrompter()
	{
		return context.getPrompter();
	}

	/**
	 * Return {@link PolicyRegistry} for test
	 *  
	 * @return {@link PolicyRegistry}
	 */
	protected
	PolicyRegistry
	getPolicies() {
		return context.getPolicyRegistry();
	}
	
	/**
	 * Return {@link VirtualFileHandler} for test
	 * 
	 * @return {@link VirtualFileHandler}
	 */
	protected
	VirtualFileHandler
	getFileHandler()
	{
		return (VirtualFileHandler) context.getFileHandler();
	}
	
	/**
	 * Return {@link Executor} for test
	 * 
	 * @return {@link Executor}
	 */
	protected
	Executor
	getExecutor()
	{
		return this.executor;
	}
	
	/**
	 * Return {@link ExecutionContext} for test
	 * 
	 * @return {@link ExecutionContext}
	 */
	protected
	ExecutionContext
	getExecutionContext()
	{
		return this.context;
	}
	
	/**
	 * Create prompter for test
	 * 
	 * @return {@link Prompter}
	 * 
	 * @see NopPrompter
	 */
	protected
	Prompter
	createPrompter()
	{
		return new NopPrompter();
	}
	
	/**
	 * Set up test
	 */
	@Before
	public void setUp()
	{
		context = new ExecutionContext( new PolicyRegistry(), createPrompter(), new VirtualFileHandler() );
	}
	
	/**
	 * Tear down test
	 */
	@After
	public void tearDown()
	{
		context = null;
	}
	
	@Test
	public
	void
	empty()
	{
	    logger.trace( "Because Test suffix is test case, it must have test method" );
	}

}
