/*
 * Common
 *
 * Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact: 
 * BonYong Lee <bonyong.lee@samsung.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
 *
 */
package org.tizen.common.core.command;

import static org.junit.Assert.assertEquals;

import org.junit.Test;
import org.tizen.common.core.command.policy.PolicyRegistry;
import org.tizen.common.core.command.prompter.NopPrompter;
import org.tizen.common.file.VirtualFileHandler;


/**
 * ExecutionContextTest
 *
 * Test case for {@link ExecutionContext}
 * 
 * @author BonYong Lee{@literal <bonyong.lee@samsung.com>} (S-Core)
 * 
 * @see ExecutionContext
 */
public class
ExecutionContextTest
{
	/**
	 * Test {@link ExecutionContext#getPolicyRegistry()}
	 * 
	 * @throws Exception in case of failure in test
	 * 
	 * @see ExecutionContext#getPolicyRegistry()
	 */
	@Test
	public void test_getPolicyRegistry() throws Exception {
		// Given
		final PolicyRegistry registry = new PolicyRegistry();
		final ExecutionContext context = new ExecutionContext( registry, null, null );
		
		// When & Then
		assertEquals( registry, context.getPolicyRegistry() );
	}
	
	/**
	 * Test {@link ExecutionContext#getPrompter()}
	 * 
	 * @throws Exception in case of failure in test
	 * 
	 * @see ExecutionContext#getPrompter()
	 */
	@Test
	public void test_getPrompter() throws Exception {
		// Given
		final NopPrompter prompter = new NopPrompter();
		final ExecutionContext context = new ExecutionContext( null, prompter, null );
		
		// When & Then
		assertEquals( prompter, context.getPrompter() );
		
	}
	
	/**
	 * Test {@link ExecutionContext#getFileHandler()}
	 * 
	 * @throws Exception in case of failure in test
	 * 
	 * @see ExecutionContext#getFileHandler()
	 */
	@Test
	public void test_getFileHandler() throws Exception {
		// Given
		final VirtualFileHandler handler = new VirtualFileHandler();
		final ExecutionContext context = new ExecutionContext( null, null, handler );
		
		// When & Then
		assertEquals( handler, context.getFileHandler() );
	}
	

}
