/*
 * Common
 *
 * Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact: 
 * BonYong Lee <bonyong.lee@samsung.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
 *
 */
package org.tizen.common.core.command.prompter;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import org.junit.Test;


/**
 * <p>
 * GenericOptionTest.
 * 
 * Test case for {@link GenericOption}
 * </p>
 * 
 * @author BonYong Lee{@literal <bonyong.lee@samsung.com>} (S-Core)
 * 
 * @see GenericOption
 */
public class
GenericOptionTest
{
	/**
	 * Test {@link GenericOption#isMatch(String)}
	 * 
	 * @throws Exception in case of failure in test
	 * 
	 * @see GenericOption#isMatch(String)
	 */
	@Test
	public
	void
	test_isMatch()
	throws Exception
	{

		final GenericOption option = new GenericOption();

		assertTrue( option.isMatch( "Hello" ) );
		assertTrue( option.isMatch( "World" ) );


	}

	/**
	 * Test {@link GenericOption#getAnswer()}
	 * 
	 * @throws Exception in case of failure in test
	 * 
	 * @see GenericOption#getAnswer()
	 */
	@Test
	public
	void
	test_getAnswer()
	throws Exception
	{
		final String userAnser = "Dummy answer";
		NopPrompter prompter = new NopPrompter() {
			@Override
			public Option interact(String question, Option... options) {
				options[0].isMatch( userAnser );
				return options[0];
			}
		};
		GenericOption option = new GenericOption();
		final Option answer = prompter.interact( "Answer ?", option );
		
		assertEquals( userAnser, ((GenericOption) answer).getAnswer() );
		assertEquals( userAnser, answer.toString() );
		
	}

}
