/*
 * Common
 *
 * Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact: 
 * BonYong Lee <bonyong.lee@samsung.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
 *
 */
package org.tizen.common.core.command.prompter;

import static org.junit.Assert.assertEquals;

import org.junit.Test;


/**
 * OptionTest
 * 
 * Test case for {@link ChoiceOption}
 * 
 * @author bylee
 *
 * @see ChoiceOption
 */
public class
OptionTest
{
	/**
	 * Test {@link ChoiceOption#isMatch(String)}
	 * 
	 * @throws Exception in case of failure in test
	 * 
	 * @see ChoiceOption#isMatch(String)
	 */
	@Test
	public
	void
	test_isMatch()
	throws Exception
	{
		// Test cases
		final Object[][] TEST_CASES = new Object[][] {
			new Object[] {
				new ChoiceOption( "test" ),
				new Object[][] {
					new Object[] { "t", true },
					new Object[] { "TEST", true },
					new Object[] { "TEst", true },
					new Object[] { "No", false },
					new Object[] { null, false }
				}
			}
		};
		// Given
		
		for ( final Object[] TEST_CASE : TEST_CASES )
		{
			
			final ChoiceOption option = (ChoiceOption) TEST_CASE[0];
			final Object[][] TEST_CASE2 = (Object[][]) TEST_CASE[1];
			for ( final Object[] TEST_CASE3 : TEST_CASE2 )
			{
				// When
				String input = (String) TEST_CASE3[0];
				boolean expected = (Boolean) TEST_CASE3[1];

				boolean result = option.isMatch( input );
				
				// Then
				assertEquals( expected, result );
			}
		}
	}

}
