/*
*  Common
*
* Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
*
* Contact: 
* GyeongSeok Seo <gyeongseok.seo@samsung.com>
* BonYong Lee <bonyong.lee@samsung.com>
* 
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
* Contributors:
* - S-Core Co., Ltd
*
*/
package org.tizen.common.core.command.sdb;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.verify;

import org.junit.Test;
import org.tizen.common.core.command.CommandTest;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.receiver.MultiLineReceiver;

/**
 * DlogSdbCommandTest
 *
 * Test case for {@link DlogSdbCommand}
 * 
 * @author GyeongSeok Seo{@literal <gyeongseok.seo@samsung.com>} (S-Core)
 * 
 * @see DlogSdbCommand
 */
public class
DlogSdbCommandTest
extends CommandTest
{
    @Test
    public void test_execute() throws Exception {
        final MultiLineReceiver mockMultiLineReceiver = mock( MultiLineReceiver.class );
        String cmd = "dlogutil";
        DlogSdbCommand testCommand = new DlogSdbCommand() {
            @Override
            public MultiLineReceiver createMultiLineReceiver() {
                return mockMultiLineReceiver;
            }
        };

        try {
            testCommand.run( null, context );
            fail( "when device is null then must throw exception" );
        } catch ( Exception e) {
        }

        IDevice mockDevice = mock( IDevice.class );
        testCommand.setDevice( mockDevice );
        try {
            testCommand.run( null, context );
            assertEquals( testCommand.getCommand(), cmd );
            verify( mockDevice ).executeShellCommand( cmd, mockMultiLineReceiver, testCommand.getTime()*1000 );

            testCommand.setFilter( "filter" );
            testCommand.run( null, context );
            assertEquals( testCommand.getCommand(), cmd + " filter" );
            verify( mockDevice ).executeShellCommand( cmd + " filter", mockMultiLineReceiver, testCommand.getTime()*1000 );
        } catch (Exception e) {
            fail( "should't throw exception" );
        }
    }
}
