/*
 * Common
 *
 * Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact: 
 * BonYong Lee <bonyong.lee@samsung.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
 *
 */
package org.tizen.common.file;

import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

import static org.junit.Assert.assertEquals;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.junit.Before;
import org.junit.Test;

public class EclipseFileHandlerTest {
    
    // variables for test
    protected final String workspacePath = "/a/b/c";
    protected final String projectName = "d";
    protected final String resourceName = "e";
    protected final IPath virtualPath = new Path( workspacePath ).append( projectName ).append( resourceName );
    
    // instances for test
    protected EclipseFileHandler fileHandler;
    protected IWorkspaceRoot mockWorkspace;
    
    @Before
    public void setUp() {
        // set default workspace
        mockWorkspace = mock( IWorkspaceRoot.class );
        when( mockWorkspace.getLocation() ).thenReturn( new Path( workspacePath ) );
        
        fileHandler = new EclipseFileHandler() {
            @Override
            protected IWorkspaceRoot getWorkspace() {
                return mockWorkspace;
            }
        };
    }
    
    @Test
    public void test_getResource() throws Exception {
        // a project in the workspace
        IProject mockProject = mock( IProject.class );
        when( mockWorkspace.getProject( projectName ) ).thenReturn( mockProject );
        when( mockProject.exists() ).thenReturn( true );
        
        // a resource in the project
        IResource mockResource = mock( IResource.class );
        when( mockProject.members() ).thenReturn( new IResource[] { mockResource } );
        when( mockResource.getName() ).thenReturn( resourceName );
        
        // run a method
        IResource resource1 = fileHandler.getResource( virtualPath.toPortableString() );
        
        // test1
        assertEquals( resource1, mockResource );
        
        
        when( mockProject.exists() ).thenReturn( false );
        
        // a file in the project
        IFile mockFile = mock( IFile.class );
        when( mockProject.getFile( resourceName ) ).thenReturn( mockFile );
        
        // run a method
        IResource resource2 = fileHandler.getResource( virtualPath.toPortableString() );
        
        // test2
        assertEquals( resource2, mockFile );
    }
    
    @Test
    public void test_getFolder() throws Exception {
        // a project in the workspace
        IProject mockProject = mock( IProject.class );
        when( mockWorkspace.getProject( projectName ) ).thenReturn( mockProject );
        when( mockProject.exists() ).thenReturn( true );
        
        // a resource in the project
        IResource mockResource = mock( IFolder.class );
        when( mockProject.members() ).thenReturn( new IResource[] { mockResource } );
        when( mockResource.getName() ).thenReturn( resourceName );
        
        // run a method
        IContainer resource1 = fileHandler.getFolder( virtualPath.toPortableString() );
        
        // test1
        assertEquals( resource1, mockResource );
        
        
        // a folder in the project
        IFolder mockFolder = mock( IFolder.class );
        when( mockProject.getFolder( resourceName ) ).thenReturn( mockFolder );
        when( mockProject.exists() ).thenReturn( false );
        
        // run a method
        IContainer resource2 = fileHandler.getFolder( virtualPath.toPortableString() );
        
        // test2
        assertEquals( resource2, mockFolder );
    }
}
