/*
 * Common
 *
 * Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact: 
 * BonYong Lee <bonyong.lee@samsung.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
 *
 */
package org.tizen.common.file;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;
import static org.tizen.common.util.ArrayUtil.size;
import static org.tizen.common.util.IOUtil.getBytes;

import java.io.File;

import org.junit.Test;
import org.tizen.common.file.VirtualFileHandler.Directory;


/**
 * <p>
 * VirtualFileHandlerTest.
 * 
 * Test case for {@link VirtualFileHandler}
 *
 * </p>
 * 
 * @author BonYong Lee{@literal <bonyong.lee@samsung.com>} (S-Core)
 * 
 * @see VirtualFileHandler
 */
public class
VirtualFileHandlerTest
{
	/**
	 * Test {@link VirtualFileHandler#write(String, String)}
	 * 
	 * @throws Exception in case of failure in test
	 * 
	 * @see VirtualFileHandler#write(String, String)
	 */
	@Test
	public
	void
	test_write()
	throws Exception
	{
		final VirtualFileHandler vfs = new VirtualFileHandler();

		vfs.makeDirectory( "/test" );

		vfs.write( "/test/a.txt", "Hello, World" );

		assertTrue( 0 < size( getBytes( vfs.read( "/test/a.txt" ) ) ) );
	}
	
	@Test
	public void test_getParent() throws Exception {
	    final String dir = "testDir";
	    final String childFilename = "a.txt";
	    final String rootFilename = "b.txt";
	    
	    String childPath = new File( dir, childFilename ).getPath();
	    
	    VirtualFileHandler fileHandler = new VirtualFileHandler();
	    
	    fileHandler.makeDirectory( dir );
	    
	    fileHandler.write( childPath, "Test child contents ");
	    fileHandler.write( rootFilename, "Test contents" );
	    
	    Directory testDir = fileHandler.getParent( childPath );
	    assertTrue( testDir != null );
	    assertEquals( testDir.getName(), dir );
	    
	    Directory rootDir = fileHandler.getParent( rootFilename );
	    assertTrue( rootDir != null );
	    assertEquals( rootDir.getName(), null );
	    
	    fileHandler.makeDirectory( "res" );
	    fileHandler.makeDirectory( "res/wgt" );
	    fileHandler.makeDirectory( "res/wgt/css" );
	    
	    final String complexPath = "res/wgt/css/fw.txt";
	    fileHandler.write( complexPath, "Oh hoho");
	    
	    fileHandler.makeDirectory( "res/zip" );
	    fileHandler.makeDirectory( "res/zip/css" );
	    final String complexPath2 = "res/zip/css/z.txt";
        fileHandler.write( complexPath2, "Oh hoho2");
        
        fileHandler.write( complexPath, "update" );
	}

}
