/*
 * Common
 *
 * Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact:
 * Ho Namkoong <ho.namkoong@samsung.com> 
 * BonYong Lee <bonyong.lee@samsung.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
 *
 */

package org.tizen.common.sdb;

import static org.junit.Assert.*;
import static org.tizen.common.sdb.SdbTestUtil.*;
import static org.tizen.common.Shell.*;

import java.text.MessageFormat;

import org.junit.Test;
import org.tizen.common.IShell;
import org.tizen.common.Pattern;
import org.tizen.common.Token;

/**
 * <p>
 * RootTest
 * 
 * Test case for sdb root on and sdb root off
 *
 * </p>
 * 
 * @author Ho Namkoong{@literal <ho.namkoong@samsung.com>} (S-Core)
 */
public class RootTest {

    class RootResult {
        @Token(from = "Switched to", to = "account mode")
        public String result;
    }
    
    /**
     * Test {sdb root on}
     * 
     * @author Ho Namkoong{@literal <ho.namkoong@samsung.com>} (S-Core) 
     */
    @Test
    public void test_root_on() throws Exception {
        
        String[] serials = getSerialNumber();
        runAndWait(MessageFormat.format("{0} -s {1} {2}", SDB_PATH, serials[0], "root off"));
        RootResult result = run(MessageFormat.format("{0} -s {1} {2}", SDB_PATH, serials[0], "root on"))
                .expect(new RootResult());
        
        assertNotNull("output of root on is null", result);
        assertEquals("'root'", result.result);
        runShellAndExpect(serials[0], "#");
    }
    
    /**
     * Test {sdb root off}
     * 
     * @author Ho Namkoong{@literal <ho.namkoong@samsung.com>} (S-Core) 
     */
    @Test
    public void test_root_off() throws Exception {
        
        String[] serials = getSerialNumber();
        runAndWait(MessageFormat.format("{0} -s {1} {2}", SDB_PATH, serials[0], "root on"));
        RootResult result = run(MessageFormat.format("{0} -s {1} {2}", SDB_PATH, serials[0], "root off")).
                expect(new RootResult());
        
        assertNotNull("output of root off is null", result);
        assertEquals("'developer'", result.result);
        runShellAndExpect(serials[0], "$");
    }

    private static void runShellAndExpect(String serial, String expect) throws Exception {
        class RootShellResult {
            @Pattern(pattern = "sh-4.1{0}exit", index = 0)
            public String token;
        }
        
        IShell shell = run(String.format("%s -s %s %s", SDB_PATH, serial, "shell"));
        shell.write("exit", 1000);
        RootShellResult result = shell.expect(new RootShellResult());
        
        assertNotNull("output of shell is null", result.token);
        assertEquals(expect, result.token);
    }
}
