/*
 * Common
 *
 * Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact:
 * Ho Namkoong <ho.namkoong@samsung.com> 
 * BonYong Lee <bonyong.lee@samsung.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
 *
 */
package org.tizen.common.sdb;

import static org.tizen.common.Shell.runAndWait;

import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import org.junit.runners.Suite.SuiteClasses;

/**
 * <p>
 * SdbTestSuite
 * 
 * Test suite for sdb test cases
 *
 * </p>
 * 
 * @author Ho Namkoong{@literal <ho.namkoong@samsung.com>} (S-Core)
 */
@RunWith(Suite.class)
@SuiteClasses({ ConnectTest.class, DevicesTest.class, GetSerialNoTest.class, 
    GetStateTest.class, InstallTest.class, PullPushTest.class, VersionTest.class,
    ShellTest.class, StatusWindowTest.class, RootTest.class, StartKillTest.class})
public class SdbTestSuite {

    @BeforeClass
    public static void prepareTest() throws Exception {
        runAndWait( SdbTestUtil.SDB_PATH + " kill-server");
        Thread.sleep(1000);
        runAndWait(SdbTestUtil.SDB_PATH + " start-server");
        Thread.sleep(1000);
    }
    
}
