/*
 * Common
 *
 * Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact:
 * Ho Namkoong <ho.namkoong@samsung.com> 
 * BonYong Lee <bonyong.lee@samsung.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
 *
 */

package org.tizen.common.sdb;

import static org.junit.Assert.*;
import static org.tizen.common.sdb.SdbTestUtil.*;

import org.junit.Test;

/**
 * <p>
 * VersionTest
 * 
 * Test case for sdb version
 *
 * </p>
 * 
 * @author Ho Namkoong{@literal <ho.namkoong@samsung.com>} (S-Core)
 */
public class VersionTest {
    
    /**
     * Test {sdb version}
     * 
     * @author Ho Namkoong{@literal <ho.namkoong@samsung.com>} (S-Core) 
     */
    @Test
    public void test_version() throws Exception {
        String[] results = runAndGetWholeString(String.format("%s %s", SdbTestUtil.SDB_PATH, "version"), true);
        assertTrue(results[0].contains("Smart Development Bridge version"));
    }

}
