/*
*  Common
*
* Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
*
* Contact: 
* BonYong Lee <bonyong.lee@samsung.com>
* 
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
* Contributors:
* - S-Core Co., Ltd
*
*/
package org.tizen.common.ui.page.wizard;

import static org.junit.Assert.assertEquals;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Composite;
import org.junit.Test;
import org.tizen.common.ui.dialog.ClosableTray;


/**
 * TrayWizardPageTest
 *
 * Test case for {@link TrayWizardPage}
 * 
 * @author BonYong Lee{@literal <bonyong.lee@samsung.com>} (S-Core)
 * 
 * @see TrayWizardPage
 */
public class
TrayWizardPageTest
{
	public void test_TrayWizardPage() throws Exception
	{
		assertEquals( "Test Page", (new TrayWizardPage( "Test Page" ) {
			public void createControl(Composite parent)
			{
			}
		}).getName() );
		
		assertEquals( "Title", (new TrayWizardPage( "Test Page", "Title", null ) {
			public void createControl(Composite parent)
			{
			}
		}).getTitle() );
	}
	@Test
	public
	void
	test_openClosableTray()
	throws Exception
	{
		final TrayWizardPage page = new TrayWizardPage( "Test Page" )
		{
			public void createControl(Composite parent)
			{
			}
		};

		/*
		 * This means that functional is successful If run on WizardDialog
		 */
		final IWizard wizard = mock( IWizard.class );
		final WizardDialog dialog = mock( WizardDialog.class );
		when( wizard.getContainer() ).thenReturn( dialog );
		final ClosableTray tray = mock( ClosableTray.class );
		
		page.setWizard( wizard );
		page.openClosableTray( tray );
		
		verify( dialog ).openTray( tray );
	}
}
