/*
*  Common
*
* Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
*
* Contact: 
* Ho Namkoong <ho.namkoong@samsung.com>
* 
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
* Contributors:
* - S-Core Co., Ltd
*
*/

package org.tizen.common.util;

import org.junit.Assert;
import org.junit.Test;

/**
 * CipherUtilTest
 *
 * Test case for {@link CipherUtil}
 * 
 * @author Ho Namkoong{@literal <ho.namkoong@samsung.com>} (S-Core)
 * 
 * @see CipherUtil
 */
public class CipherUtilTest {

    /**
     * Original password list which should be encrypted
     */
    private static final String[] passList = {"1234", "wiehj2j3hxcgf", "0932hsdhgfasdf", "kj2h3ejaswdas"};
    
    /**
     * Encrypted password
     */
    private String[] encryptedPassList = new String[passList.length];
    
    /**
     * Decrypted password
     */
    private String[] decryptedPassList = new String[passList.length];
    
    /**
     * Test {@link CipherUtil#getEncryptedString(String)}
     * 
     * @throws Exception in case of failure in test
     * 
     * @see CipherUtil#getEncryptedString(String)
     */
    private void test_getEncryptedBase64String() throws Exception {
        for (int i = 0; i < passList.length; i++) {
            encryptedPassList[i] = CipherUtil.getEncryptedString(passList[i]);
            Assert.assertNotNull(encryptedPassList[i]);
        }
    }
    
    /**
     * Test {@link CipherUtil#getDecryptedString(String)}
     * 
     * @throws Exception in case of failure in test
     * 
     * @see CipherUtil#getDecryptedString(String)
     */
    private void test_getDecryptedString() throws Exception {
        for(int i=0; i<encryptedPassList.length;i++) {
            decryptedPassList[i] = CipherUtil.getDecryptedString(encryptedPassList[i]);
            Assert.assertNotNull(decryptedPassList[i]);
        }
    }
    
    @Test
    public void test_cipher() throws Exception {
        this.test_getEncryptedBase64String();
        this.test_getDecryptedString();
        
        for (int i = 0; i < passList.length; i++) {
            Assert.assertTrue(passList[i].equals(decryptedPassList[i]));
        }
    }
}
