/*
*  Common
*
* Copyright (c) 2015 Samsung Electronics Co., Ltd. All rights reserved.
*
* Contact: 
* Sang-hyun Lee <sanghyunnim.lee@samsung.com>
* 
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
* Contributors:
* - S-Core Co., Ltd
*
*/

package org.tizen.common.util;

import static org.junit.Assert.*;

import org.junit.Test;

/**
 * UnitConvertUtilTest
 * 
 * Test cases for {@link UnitConvertUtil}
 * 
 * @author Sang-hyun Lee{@literal <sanghyunnim.lee@samsung.com>} (S-Core)
 * 
 * @see UnitConvertUtil
 */
public class UnitConvertUtilTest {
    /**
     * @throws Exception in case of failure in test
     * 
     * @see UnitConvertUtil#toByteUnitString(long)
     */
    @Test
    public void test_toByteUnitString() throws Exception {
        assertEquals("0 B", UnitConvertUtil.toByteUnitString(0));
        assertEquals("1 B", UnitConvertUtil.toByteUnitString(1));
        assertEquals("1023 B", UnitConvertUtil.toByteUnitString(1023));
        assertEquals("1.00 KB", UnitConvertUtil.toByteUnitString(1024));
        assertEquals("1.00 KB", UnitConvertUtil.toByteUnitString(1025));
        assertEquals("1.00 MB", UnitConvertUtil.toByteUnitString(1024 * 1024));
        assertEquals("1.50 MB", UnitConvertUtil.toByteUnitString(1024 * 1024 + 1024 * 1024 / 2));
        assertEquals("1.00 GB", UnitConvertUtil.toByteUnitString(1024 * 1024 * 1024));
        assertEquals("1.50 GB", UnitConvertUtil.toByteUnitString(1024 * 1024 * 1024 + 1024 * 1024 * 1024 / 2));
    }
}
