/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.model.schema;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.tizen.common.rest.model.RepositoryManager;
import org.tizen.common.rest.model.schema.AbstractWadlModel;
import org.tizen.common.rest.model.schema.Doc;
import org.tizen.common.rest.model.schema.Grammars;
import org.tizen.common.rest.model.schema.IRestUiModel;
import org.tizen.common.rest.model.schema.IWadlModel;
import org.tizen.common.rest.model.schema.Method;
import org.tizen.common.rest.model.schema.Param;
import org.tizen.common.rest.model.schema.Representation;
import org.tizen.common.rest.model.schema.ResourceType;
import org.tizen.common.rest.model.schema.Resources;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"doc", "grammars", "resources", "resourceTypeOrMethodOrRepresentation", "any"})
@XmlRootElement(name="application")
public class Application
extends AbstractWadlModel
implements IRestUiModel {
    protected List<Doc> doc;
    protected Grammars grammars;
    protected List<Resources> resources;
    @XmlElements(value={@XmlElement(name="resource_type", type=ResourceType.class), @XmlElement(name="method", type=Method.class), @XmlElement(name="representation", type=Representation.class), @XmlElement(name="param", type=Param.class)})
    protected List<IWadlModel> resourceTypeOrMethodOrRepresentation;
    @XmlAnyElement(lax=true)
    protected List<Object> any;

    public Application() {
    }

    public Application(String title) {
        this.setTitle(title);
    }

    @Override
    public List<IWadlModel> getChildren() {
        ArrayList<IWadlModel> list = new ArrayList<IWadlModel>();
        Grammars grammars = this.getGrammars();
        if (grammars != null) {
            list.add(this.getGrammars());
        }
        list.addAll(this.getDoc());
        list.addAll(this.getResources());
        list.addAll(this.getResourceTypeOrMethodOrRepresentation());
        return list;
    }

    public List<Doc> getDoc() {
        if (this.doc == null) {
            this.doc = new ArrayList<Doc>();
        }
        return this.doc;
    }

    public Grammars getGrammars() {
        return this.grammars;
    }

    public void setGrammars(Grammars value) {
        this.grammars = value;
    }

    public List<Resources> getResources() {
        if (this.resources == null) {
            this.resources = new ArrayList<Resources>();
        }
        return this.resources;
    }

    public List<IWadlModel> getResourceTypeOrMethodOrRepresentation() {
        if (this.resourceTypeOrMethodOrRepresentation == null) {
            this.resourceTypeOrMethodOrRepresentation = new ArrayList<IWadlModel>();
        }
        return this.resourceTypeOrMethodOrRepresentation;
    }

    public List<Representation> getRepresentation() {
        ArrayList<Representation> representations = new ArrayList<Representation>();
        for (IWadlModel model : this.resourceTypeOrMethodOrRepresentation) {
            if (!(model instanceof Representation)) continue;
            representations.add((Representation)model);
        }
        return representations;
    }

    public List<Param> getParam() {
        ArrayList<Param> params = new ArrayList<Param>();
        for (IWadlModel model : this.resourceTypeOrMethodOrRepresentation) {
            if (!(model instanceof Param)) continue;
            params.add((Param)model);
        }
        return params;
    }

    public List<Object> getAny() {
        if (this.any == null) {
            this.any = new ArrayList<Object>();
        }
        return this.any;
    }

    public void setTitle(String value) {
        super.setTitle(this.getDoc(), value);
    }

    public String getTitle() {
        String title = super.getTitle(this.getDoc());
        if (title == null) {
            title = RepositoryManager.getInstance().extractTitle(this);
        }
        return title;
    }

    @Override
    public void addChild(IRestUiModel model) {
        if (model instanceof Resources) {
            Resources resources = (Resources)model;
            this.getResources().add(resources);
            resources.setParent(this);
        } else if (model instanceof Method || model instanceof Representation || model instanceof Param) {
            this.getResourceTypeOrMethodOrRepresentation().add(model);
            ((AbstractWadlModel)((Object)model)).setParent(this);
        }
    }

    @Override
    public void removeChild(IRestUiModel model) {
        if (model instanceof Resources) {
            Resources resources = (Resources)model;
            this.getResources().remove(model);
            resources.setParent(null);
        } else if (model instanceof Param) {
            Param param = (Param)model;
            this.getResourceTypeOrMethodOrRepresentation().remove(model);
            param.setParent(null);
        }
    }

    @Override
    public boolean isVaildChild(IRestUiModel model) {
        return model instanceof Resources;
    }

    @Override
    public IRestUiModel update(IRestUiModel updateModel) {
        Application app = (Application)updateModel;
        this.setTitle(app.getTitle());
        return this;
    }

    @Override
    public void delete() {
        RepositoryManager.getInstance().removeApplication(this);
    }

    @Override
    public String getElementId() {
        File file;
        RepositoryManager rManager = RepositoryManager.getInstance();
        String title = rManager.extractTitle(this);
        if (this.getElementName().equals(title) && (file = rManager.getFile(this)) != null) {
            title = file.getName();
        }
        return title;
    }

    @Override
    public String getDisplayName() {
        return "Service";
    }

    @Override
    public void insertBefore(IRestUiModel model, IRestUiModel target) {
        this.insert(model, target, true);
    }

    @Override
    public void insertAfter(IRestUiModel model, IRestUiModel target) {
        this.insert(model, target, false);
    }

    private void insert(IRestUiModel model, IRestUiModel target, boolean isBefore) {
        if (model instanceof Resources && target instanceof Resources) {
            int index = this.getResources().indexOf(target);
            if (index > -1) {
                Resources res = (Resources)model;
                this.getResources().add(isBefore ? index : index + 1, res);
                res.setParent(this);
            }
        } else {
            int index = this.getResourceTypeOrMethodOrRepresentation().indexOf(target);
            if (index > -1) {
                this.getResourceTypeOrMethodOrRepresentation().add(isBefore ? index : index + 1, model);
                ((AbstractWadlModel)((Object)model)).setParent(this);
            }
        }
    }
}

