/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdblib.receiver;

import java.util.Collection;
import java.util.TreeSet;
import org.tizen.sdblib.receiver.FileEntryFactory;
import org.tizen.sdblib.receiver.MultiLineReceiver;
import org.tizen.sdblib.service.FileEntry;

public class LsReceiver
extends MultiLineReceiver {
    public static final String CMD_LS_WITH_STYLE = "ls -lF %s --time-style=long-iso --show-control-chars 2> /dev/null";
    public static final String CMD_SECURE_LS = "0 list";
    public static final String CMD_SECURE_LS_WITH_STYLE = "0 list_showcontrol";
    protected final FileEntry parent;
    protected final TreeSet<FileEntry> entries = new TreeSet();

    public LsReceiver(FileEntry parent) {
        this.parent = parent;
    }

    @Override
    public void processNewLines(String[] lines) {
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            FileEntry entry;
            String line = stringArray[n2];
            if (line.length() != 0 && (entry = FileEntryFactory.create(this.parent, line)) != null) {
                this.entries.add(entry);
            }
            ++n2;
        }
    }

    public Collection<FileEntry> getEntries() {
        return this.entries;
    }
}

