/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.controller;

import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.util.Callback;
import org.tizen.device.manager.model.DeviceItem;
import org.tizen.device.manager.model.DeviceTypeImageData;
import org.tizen.device.manager.resources.ROW_STATE;

public class DeviceNameCell
extends TableCell<DeviceItem, String> {
    private SimpleObjectProperty<ROW_STATE> prop;
    private ImageView icon;
    private ImageView selectedIcon;
    private ImageView overIcon;
    private ImageView tooltipIcon;
    private ChangeListener<ROW_STATE> listener = new ChangeListener<ROW_STATE>(){

        public void changed(ObservableValue<? extends ROW_STATE> arg, ROW_STATE oldValue, ROW_STATE newValue) {
            DeviceNameCell.this.setIcon(newValue);
        }
    };

    protected void updateItem(String item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
            this.setTooltip(null);
            if (this.prop != null) {
                this.prop.removeListener(this.listener);
            }
            return;
        }
        DeviceItem deviceItem = (DeviceItem)this.getTableRow().getItem();
        if (item == null || deviceItem == null) {
            return;
        }
        this.setText(item);
        if (deviceItem.getDeviceTypeImageData() == null) {
            this.setText(null);
            this.setGraphic(null);
            this.setTooltip(null);
            if (this.prop != null) {
                this.prop.removeListener(this.listener);
            }
            return;
        }
        DeviceTypeImageData imageData = deviceItem.getDeviceTypeImageData();
        this.icon = new ImageView(imageData.getIcon());
        this.selectedIcon = new ImageView(imageData.getSelectedIcon());
        this.overIcon = new ImageView(imageData.getOverIcon());
        this.tooltipIcon = new ImageView(imageData.getTooltipIcon());
        if (this.prop != null) {
            this.prop.removeListener(this.listener);
        }
        this.prop = deviceItem.getRowState();
        this.prop.addListener(this.listener);
        this.setIcon((ROW_STATE)((Object)this.prop.get()));
        Tooltip tooltip = new Tooltip();
        tooltip.setGraphic((Node)this.tooltipIcon);
        this.setTooltip(tooltip);
    }

    private void setIcon(ROW_STATE state) {
        switch (state) {
            case NORMAL: {
                this.setGraphic((Node)this.icon);
                break;
            }
            case OVER: {
                this.setGraphic((Node)this.overIcon);
                break;
            }
            case SELECTED: {
                this.setGraphic((Node)this.selectedIcon);
                break;
            }
            default: {
                this.setGraphic(null);
            }
        }
    }

    public static Callback<TableColumn<DeviceItem, String>, TableCell<DeviceItem, String>> extractor() {
        return new Callback<TableColumn<DeviceItem, String>, TableCell<DeviceItem, String>>(){

            public TableCell<DeviceItem, String> call(TableColumn<DeviceItem, String> param) {
                DeviceNameCell cell = new DeviceNameCell();
                cell.getStyleClass().add((Object)"device-cell");
                return cell;
            }
        };
    }
}

