/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.controller;

import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;
import org.tizen.device.manager.Messages;
import org.tizen.device.manager.controller.TableSelectionListener;
import org.tizen.device.manager.logging.DeviceLogger;
import org.tizen.device.manager.model.DeviceEventHandler;
import org.tizen.device.manager.model.DeviceItem;
import org.tizen.device.manager.resources.ROW_STATE;

public class DeviceTableRow
extends TableRow<DeviceItem> {
    private final TableView<DeviceItem> table;
    private final ContextMenu contextMenu = new ContextMenu();
    private final MenuItem mAddLogTab = new MenuItem(Messages.Device_Table_Context_Menu_Label_Add_Log_Tab);
    private final MenuItem mDeleteLogTabs = new MenuItem(Messages.Device_Table_Context_Menu_Label_Delete_Log_Tab);
    private final MenuItem mConnect = new MenuItem(Messages.Device_Table_Context_Menu_Label_Connect);
    private final MenuItem mDisconnect = new MenuItem(Messages.Device_Table_Context_Menu_Label_Disconnet);
    private final MenuItem mAppInstall = new MenuItem(Messages.Device_Table_Context_Menu_Label_Install_App);
    private final EventHandler<MouseEvent> mouseEvent = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            DeviceTableRow.this.mouseEventHandler(event);
        }
    };

    DeviceTableRow(final TableView<DeviceItem> table) {
        this.table = table;
        this.setOnMouseClicked(this.mouseEvent);
        this.setOnMouseEntered(this.mouseEvent);
        this.setOnMouseExited(this.mouseEvent);
        ObservableList items = this.contextMenu.getItems();
        items.add((Object)this.mAppInstall);
        items.add((Object)new SeparatorMenuItem());
        items.add((Object)this.mAddLogTab);
        items.add((Object)this.mDeleteLogTabs);
        items.add((Object)new SeparatorMenuItem());
        items.add((Object)this.mConnect);
        items.add((Object)this.mDisconnect);
        this.mAddLogTab.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                DeviceLogger.getLogger().fine("Click adds log tab menu");
                DeviceEventHandler.addLogTab((DeviceItem)table.getSelectionModel().getSelectedItems().get(0));
            }
        });
        this.mDeleteLogTabs.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                DeviceLogger.getLogger().fine("Click delete log tabs menu");
                DeviceEventHandler.deleteLogTabs((DeviceItem)table.getSelectionModel().getSelectedItems().get(0));
            }
        });
        this.mConnect.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                DeviceLogger.getLogger().fine("Click connect remote device menu");
                DeviceEventHandler.connectRemoteDevice((DeviceItem)table.getSelectionModel().getSelectedItems().get(0));
            }
        });
        this.mDisconnect.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                DeviceLogger.getLogger().fine("Click disconncet remote device menu");
                DeviceEventHandler.disConnectRemoteDevice((DeviceItem)table.getSelectionModel().getSelectedItems().get(0));
            }
        });
        this.mAppInstall.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                DeviceLogger.getLogger().fine("Click install app to device");
                DeviceEventHandler.appInstallToDevice((DeviceItem)table.getSelectionModel().getSelectedItems().get(0));
            }
        });
    }

    void mouseEventHandler(MouseEvent event) {
        DeviceItem deviceItem = (DeviceItem)this.getItem();
        if (deviceItem == null) {
            return;
        }
        EventType type = event.getEventType();
        if (type == MouseEvent.MOUSE_CLICKED) {
            ObservableList selectedItem = this.table.getSelectionModel().getSelectedItems();
            if (selectedItem == null) {
                return;
            }
            if (event.getButton() == MouseButton.SECONDARY) {
                if (selectedItem.size() == 0) {
                    return;
                }
                boolean disableLogTab = TableSelectionListener.getDisableLogTab().get();
                boolean disableConnect = TableSelectionListener.getDisableConnect().get();
                boolean disableDisconnect = TableSelectionListener.getDisableDisConnect().get();
                this.mAddLogTab.setDisable(disableLogTab);
                this.mDeleteLogTabs.setDisable(disableLogTab);
                this.mConnect.setDisable(disableConnect);
                this.mDisconnect.setDisable(disableDisconnect);
                this.mAppInstall.setDisable(disableLogTab);
                this.contextMenu.show((Node)this, event.getScreenX(), event.getScreenY());
            }
            return;
        }
        if (this.selectedProperty().get()) {
            return;
        }
        if (type == MouseEvent.MOUSE_ENTERED) {
            deviceItem.setRowState(ROW_STATE.OVER);
        } else {
            deviceItem.setRowState(ROW_STATE.NORMAL);
        }
    }

    public static Callback<TableView<DeviceItem>, TableRow<DeviceItem>> extractor() {
        return new Callback<TableView<DeviceItem>, TableRow<DeviceItem>>(){

            public TableRow<DeviceItem> call(TableView<DeviceItem> table) {
                DeviceTableRow row = new DeviceTableRow(table);
                return row;
            }
        };
    }
}

