/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.control;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.tizen.device.manager.Main;
import org.tizen.device.manager.Messages;
import org.tizen.device.manager.control.SDBFileSyncController;
import org.tizen.device.manager.control.SigningProfileUtilController;
import org.tizen.device.manager.file.explorer.FileEntryTreeData;
import org.tizen.device.manager.logging.DeviceLogger;
import org.tizen.device.manager.ui.diaglog.FileDialogUtils;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.service.FileEntry;

public class FilePushPullController {
    public static void pushToDevice(FileEntryTreeData selectTreeData, TreeView<FileEntryTreeData> treeView) {
        if (selectTreeData == null) {
            return;
        }
        if (!selectTreeData.getFileEntry().isDirectory()) {
            FileDialogUtils.confirmPushDirectory(selectTreeData.getFileEntry().getName());
            return;
        }
        FileChooser chooser = new FileChooser();
        FilePushPullController.configureFileChooser(chooser);
        List list = chooser.showOpenMultipleDialog((Window)Main.getPrimaryStage());
        if (list == null || list.size() < 1) {
            return;
        }
        ArrayList<String> fromFileList = new ArrayList<String>();
        for (File file : list) {
            fromFileList.add(file.getAbsolutePath());
        }
        String[] fromFileData = fromFileList.toArray(new String[0]);
        selectTreeData.setTreeItemState(FileEntryTreeData.TreeItemState.CHILD_NOT_CHECKED);
        SDBFileSyncController.pushFiles(fromFileData, selectTreeData, treeView);
    }

    public static void pullFromDevice(IDevice selectDevice, TreeView<FileEntryTreeData> treeView) {
        if (selectDevice == null) {
            return;
        }
        FileEntry[] fileEntryArr = FilePushPullController.getSelectedTreeItems(treeView);
        DirectoryChooser directoryChooser = new DirectoryChooser();
        FilePushPullController.configureFileChooser(directoryChooser);
        File selectedDirectory = directoryChooser.showDialog((Window)Main.getPrimaryStage());
        if (selectedDirectory == null) {
            return;
        }
        SDBFileSyncController.pullFiles(selectDevice, fileEntryArr, selectedDirectory.getAbsolutePath());
    }

    public static void pushToDeviceProfile(FileEntryTreeData selectTreeData, TreeView<FileEntryTreeData> treeView) {
        if (selectTreeData == null) {
            return;
        }
        SigningProfileUtilController.setRetryTreeviewData(selectTreeData, treeView);
        File activeProfile = SigningProfileUtilController.activeSignDeviceProfilePath();
        if (activeProfile == null || !activeProfile.exists()) {
            return;
        }
        ArrayList<String> fromFileList = new ArrayList<String>();
        fromFileList.add(activeProfile.getAbsolutePath());
        String[] fromFileData = fromFileList.toArray(new String[0]);
        String certPath = SigningProfileUtilController.getCertTargetPath(selectTreeData.getFileEntry().getDevice());
        if (certPath == null) {
            return;
        }
        boolean isCheckDUI = SigningProfileUtilController.checkDUIDTOTagetDevice(selectTreeData.getFileEntry().getDevice(), activeProfile.getAbsolutePath());
        if (!isCheckDUI) {
            return;
        }
        FileEntryTreeData targetEntry = new FileEntryTreeData(selectTreeData.getFileEntry().getDevice().getFileEntry(certPath));
        targetEntry.setTreeItemState(FileEntryTreeData.TreeItemState.CHILD_NOT_CHECKED);
        SDBFileSyncController.permitToInstall(fromFileData, targetEntry, treeView);
    }

    private static void configureFileChooser(FileChooser fileChooser) {
        fileChooser.setTitle(Messages.FileDialog_Push_Title);
        fileChooser.setInitialDirectory(new File(System.getProperty("user.home")));
    }

    private static void appInstallConfigureFileChooser(FileChooser fileChooser) {
        fileChooser.setTitle(Messages.FileDialog_Push_Title);
        fileChooser.setInitialDirectory(new File(System.getProperty("user.home")));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Tizen App Files", new String[]{"*.wgt", "*.tpk"}));
    }

    private static void configureFileChooser(DirectoryChooser directoryChooser) {
        directoryChooser.setTitle(Messages.FileDialog_Pull_Title);
        directoryChooser.setInitialDirectory(new File(System.getProperty("user.home")));
    }

    private static FileEntry[] getSelectedTreeItems(TreeView<FileEntryTreeData> treeView) {
        ObservableList selectTreeData = treeView.getSelectionModel().getSelectedItems();
        if (selectTreeData.isEmpty()) {
            DeviceLogger.getLogger().warning("Selected Tree item list is empty...");
        }
        FileEntry[] fileEntryArr = new FileEntry[selectTreeData.size()];
        for (int i = 0; i < selectTreeData.size(); ++i) {
            fileEntryArr[i] = ((FileEntryTreeData)((TreeItem)selectTreeData.get(i)).getValue()).getFileEntry();
        }
        return fileEntryArr;
    }

    public static File getInstallAppPath() {
        FileChooser chooser = new FileChooser();
        FilePushPullController.appInstallConfigureFileChooser(chooser);
        File file = chooser.showOpenDialog((Window)Main.getPrimaryStage());
        if (file == null) {
            return null;
        }
        return file;
    }
}

