/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.controller;

import java.util.ArrayList;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.ListChangeListener;
import javafx.scene.control.TableView;
import org.tizen.device.manager.data.DeviceStateType;
import org.tizen.device.manager.model.DeviceItem;
import org.tizen.device.manager.resources.ROW_STATE;

public class TableSelectionListener
implements ListChangeListener<Integer> {
    private final TableView<DeviceItem> table;
    private static SimpleBooleanProperty disableLogTab = new SimpleBooleanProperty(true);
    private static SimpleBooleanProperty disableConnect = new SimpleBooleanProperty(true);
    private static SimpleBooleanProperty disableDisConnect = new SimpleBooleanProperty(true);

    public TableSelectionListener(TableView<DeviceItem> vmTable) {
        this.table = vmTable;
    }

    public static SimpleBooleanProperty getDisableLogTab() {
        return disableLogTab;
    }

    public static SimpleBooleanProperty getDisableConnect() {
        return disableConnect;
    }

    public static SimpleBooleanProperty getDisableDisConnect() {
        return disableDisConnect;
    }

    public void onChanged(ListChangeListener.Change<? extends Integer> change) {
        for (DeviceItem item : this.table.getItems()) {
            if (item.getRowState().get() != ROW_STATE.SELECTED) continue;
            item.setRowState(ROW_STATE.NORMAL);
        }
        ArrayList<Object> selectedItems = new ArrayList<Object>();
        for (int i = 0; i < this.table.getItems().size(); ++i) {
            if (!this.table.getSelectionModel().isSelected(i)) continue;
            selectedItems.add(this.table.getItems().get(i));
        }
        for (DeviceItem deviceItem : selectedItems) {
            deviceItem.setRowState(ROW_STATE.SELECTED);
        }
        DeviceItem selectItem = (DeviceItem)this.table.getSelectionModel().getSelectedItems().get(0);
        if (selectItem == null) {
            return;
        }
        if (!selectItem.getDeviceType().isRemoteDevice()) {
            disableLogTab.set(false);
            disableConnect.set(true);
            disableDisConnect.set(true);
        } else if (selectItem.connectProperty().getValue().equalsIgnoreCase(DeviceStateType.ONLINE.name())) {
            disableLogTab.set(false);
            disableConnect.set(true);
            disableDisConnect.set(false);
        } else {
            disableLogTab.set(true);
            disableConnect.set(false);
            disableDisConnect.set(true);
        }
    }
}

