/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.model;

import java.util.List;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import org.tizen.device.manager.control.FilePushPullController;
import org.tizen.device.manager.control.SDBFileSyncController;
import org.tizen.device.manager.file.explorer.FileEntryTreeData;
import org.tizen.device.manager.logging.DeviceLogger;

public class DeviceFileExplorerEventHandler {
    public static void addNewFileToDevice(FileEntryTreeData fileEntryTreeData, TreeView<FileEntryTreeData> selectTreeData) {
        if (fileEntryTreeData == null) {
            return;
        }
        DeviceLogger.getLogger().fine("Start progress indicator for new file: " + fileEntryTreeData.getFileEntry().getName());
        SDBFileSyncController.addNewFile(fileEntryTreeData, selectTreeData);
    }

    public static void addNewFolderToDevice(FileEntryTreeData fileEntryTreeData, TreeView<FileEntryTreeData> selectTreeData) {
        if (fileEntryTreeData == null) {
            return;
        }
        DeviceLogger.getLogger().fine("Start progress indicator for new folder: " + fileEntryTreeData.getFileEntry().getName());
        SDBFileSyncController.addNewFolder(fileEntryTreeData, selectTreeData);
    }

    public static void renameToDevice(FileEntryTreeData fileEntryTreeData, TreeView<FileEntryTreeData> selectTreeData) {
        if (fileEntryTreeData == null) {
            return;
        }
        DeviceLogger.getLogger().fine("Start progress indicator for rename file and folder: " + fileEntryTreeData.getFileEntry().getName());
        SDBFileSyncController.renameToFileAndFolder(fileEntryTreeData, selectTreeData);
    }

    public static void deleteToDevice(List<TreeItem<FileEntryTreeData>> deleteSelectTreeItems, TreeView<FileEntryTreeData> selectTreeData) {
        if (deleteSelectTreeItems == null) {
            return;
        }
        DeviceLogger.getLogger().fine("Start progress indicator for delete file and folder: ");
        SDBFileSyncController.deleteToFileAndFolder(deleteSelectTreeItems, selectTreeData);
    }

    public static void pushToDevice(FileEntryTreeData fileEntryTreeData, TreeView<FileEntryTreeData> selectTreeData) {
        if (fileEntryTreeData == null || selectTreeData == null) {
            return;
        }
        DeviceLogger.getLogger().fine("Start progress indicator for push to device: ");
        FilePushPullController.pushToDevice(fileEntryTreeData, selectTreeData);
    }

    public static void pullFromDevice(FileEntryTreeData fileEntryTreeData, TreeView<FileEntryTreeData> selectTreeData) {
        if (fileEntryTreeData == null || selectTreeData == null) {
            return;
        }
        DeviceLogger.getLogger().fine("Start progress indicator for pull from device: ");
        FilePushPullController.pullFromDevice(fileEntryTreeData.getFileEntry().getDevice(), selectTreeData);
    }

    public static void refreshToDevice(FileEntryTreeData fileEntryTreeData, TreeView<FileEntryTreeData> selectTreeData) {
        if (fileEntryTreeData == null) {
            return;
        }
        DeviceLogger.getLogger().fine("Start progress indicator for refresh file and folder: " + fileEntryTreeData.getFileEntry().getName());
        SDBFileSyncController.refreshToFileAndFolder(fileEntryTreeData, selectTreeData);
    }

    public static void openShellToDevice(FileEntryTreeData fileEntryTreeData) {
        if (fileEntryTreeData == null) {
            return;
        }
        fileEntryTreeData.getFileEntry().getDevice();
        DeviceLogger.getLogger().fine("Start progress indicator for open shell: " + fileEntryTreeData.getFileEntry().getName());
        SDBFileSyncController.openShellToDevice(fileEntryTreeData.getFileEntry().getDevice());
    }

    public static void showProperty(FileEntryTreeData fileEntryTreeData, TreeView<FileEntryTreeData> selectTreeData) {
        if (fileEntryTreeData == null) {
            return;
        }
        DeviceLogger.getLogger().fine("Start progress indicator for show property the file entry: " + fileEntryTreeData.getFileEntry().getName());
        SDBFileSyncController.showPropertyToFileEntry(fileEntryTreeData, selectTreeData);
    }

    public static void permitToInstall(FileEntryTreeData fileEntryTreeData, TreeView<FileEntryTreeData> selectTreeData) {
        if (fileEntryTreeData == null || selectTreeData == null) {
            return;
        }
        DeviceLogger.getLogger().fine("Start progress indicator for permit to install: ");
        FilePushPullController.pushToDeviceProfile(fileEntryTreeData, selectTreeData);
    }
}

