/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.ui.diaglog;

import org.tizen.device.manager.Messages;
import org.tizen.device.manager.ui.diaglog.ButtonType;
import org.tizen.device.manager.ui.diaglog.CheckReturn;
import org.tizen.device.manager.ui.diaglog.MessageBox;

public class FileDialogUtils {
    public static final int YES_ID = 0;
    public static final int YES_TO_ALL_ID = 1;
    public static final int NO_ID = 2;
    public static final int CANCEL_ID = 3;

    public static ButtonType pushFileErrorMessage(String errorMsg) {
        String message = Messages.FileDialog_Push_Fail_Items + "\n" + errorMsg;
        return MessageBox.error(Messages.FileDialog_Error_Title, message);
    }

    public static ButtonType pullFileErrorMessage(String errorMsg) {
        String message = Messages.FileDialog_Pull_Fail_Items + "\n" + errorMsg;
        return MessageBox.error(Messages.FileDialog_Error_Title, message);
    }

    public static ButtonType permitErrorMessage(String errorMsg) {
        String message = Messages.FileDialog_Permit_Fail_Items + "\n" + errorMsg;
        return MessageBox.error(Messages.FileDialog_Error_Title, message);
    }

    public static ButtonType successPopupMessage(String popupMessage) {
        return MessageBox.error(Messages.FileDialog_Message_Title, popupMessage);
    }

    public static ButtonType confirmPushDirectory(String selectName) {
        String message = String.format(Messages.FileDialog_Push_Select_Directory, selectName);
        ButtonType resultBtn = MessageBox.confirm(Messages.FileDialog_Message_Title, message, ButtonType.OK);
        return resultBtn;
    }

    public static ButtonType checkOverwrite(String filename) {
        String message = String.format(Messages.FileDialog_Overwrite_Message, filename);
        ButtonType resultBtn = MessageBox.confirm(Messages.FileDialog_Message_Title, message, ButtonType.YES, ButtonType.YESTOALL, ButtonType.NO);
        return resultBtn;
    }

    public static ButtonType allowFileOverwrite(String filename) {
        String message = String.format(Messages.FileDialog_Overwrite_Message, filename);
        ButtonType resultBtn = MessageBox.confirm(Messages.FileDialog_Message_Title, message, ButtonType.OK);
        return resultBtn;
    }

    public static ButtonType remoteDeviceConnectErrorMessage(String errorMsg) {
        String message = errorMsg + "\n\n" + Messages.Remote_Device_Manager_Connect_Failure;
        return MessageBox.error(Messages.FileDialog_Error_Title, message);
    }

    public static ButtonType remoteAddDeviceErrorMessage(String ipPort) {
        String message = ipPort + "\n" + Messages.Remote_Device_Manager_Add_Device_SameValue;
        return MessageBox.error(Messages.FileDialog_Error_Title, message);
    }

    public static ButtonType remoteAddDeviceInvalidPortErrorMessage(String port) {
        String message = "\"" + port + "\" " + Messages.Remote_Device_Manager_InvalidPort;
        return MessageBox.error(Messages.FileDialog_Error_Title, message);
    }

    public static ButtonType remoteAddDeviceInvalidIpErrorMessage(String ip) {
        String message = "\"" + ip + "\" " + Messages.Remote_Device_Manager_InvalidIp;
        return MessageBox.error(Messages.FileDialog_Error_Title, message);
    }

    public static ButtonType remoteAddDeviceEmptyNameErrorMessage() {
        String message = Messages.Remote_Device_Manager_EmptyName;
        return MessageBox.error(Messages.FileDialog_Error_Title, message);
    }

    public static ButtonType allowDeleteAllLogTabs(String deviceSerialName) {
        String message = String.format(Messages.FileDialog_Delete_All_Log_Tabs_Message, deviceSerialName);
        ButtonType resultBtn = MessageBox.confirm(Messages.FileDialog_Message_Title, message, ButtonType.OK);
        return resultBtn;
    }

    public static ButtonType impossibleDeleteAllLogTabs(String deviceSerialName) {
        String message = String.format(Messages.FileDialog_Delete_ALL_Log_Tabs_Impossible_Message, deviceSerialName);
        ButtonType resultBtn = MessageBox.confirm(Messages.FileDialog_Message_Title, message, ButtonType.OK);
        return resultBtn;
    }

    public static CheckReturn inputMessageBox(String title, String guideMessage, String initInputMessage) {
        CheckReturn ret = MessageBox.fileExplorerInputBox(title, guideMessage, initInputMessage);
        return ret;
    }

    public static ButtonType notifyDuplication(String filename) {
        String message = String.format(Messages.FileDialog_Duplicate_Message, filename);
        ButtonType resultBtn = MessageBox.confirm(Messages.FileDialog_Message_Title, message, ButtonType.OK);
        return resultBtn;
    }

    public static ButtonType fileExplorerErrorMessage(String errorMsg, String detailErrorMsg) {
        String message = errorMsg + "\n\nReason:\n" + detailErrorMsg;
        return MessageBox.error(Messages.FileDialog_Error_Title, message);
    }

    public static ButtonType allowDeleteToFileAndFolder(String deleteName) {
        String message = String.format(Messages.FileDialog_Delete_Message, deleteName);
        ButtonType resultBtn = MessageBox.confirm(Messages.FileDialog_Message_Title, message, ButtonType.OK);
        return resultBtn;
    }

    public static ButtonType openShellErrorMessage(String errorMsg) {
        String message = Messages.FileDialog_Open_Shell_Error_Message + "\n" + errorMsg;
        return MessageBox.error(Messages.FileDialog_Error_Title, message);
    }

    public static ButtonType permitToInstallErrorMessageToPopup(String errorMsg) {
        return MessageBox.popupToCertificate(Messages.FileDialog_Error_Title, errorMsg);
    }

    public static ButtonType permitToInstallInfoMessageToPopup(String errorMsg) {
        return MessageBox.popupToCertificate(Messages.FileDialog_Message_Title, errorMsg);
    }

    public static ButtonType permitToInstallErrorMessage(String errorMsg) {
        String message = Messages.FileDialog_Permit_To_Install_Error_Message + "\n" + errorMsg;
        return MessageBox.error(Messages.FileDialog_Error_Title, message);
    }

    public static ButtonType permitToInstallInfoMessage(String errorMsg) {
        return MessageBox.error(Messages.FileDialog_Message_Title, errorMsg);
    }

    public static ButtonType permitToInstallSuccessMessage(String msg) {
        return MessageBox.error(Messages.FileDialog_Message_Title, msg);
    }
}

