/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.ui.diaglog;

import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import org.tizen.device.manager.Messages;
import org.tizen.device.manager.ui.diaglog.IFileEntryPropertyPage;
import org.tizen.sdblib.service.FileEntry;

public class FileEntryPropertyInfoPage
implements IFileEntryPropertyPage {
    private BorderPane borderPane;
    private FileEntry fileEntry;
    private static final String PATH_TITLE = Messages.Properties_Dialog_Label_Path;
    private static final String TYPE_TITLE = Messages.Properties_Dialog_Label_Type;
    private static final String SIZE_TITLE = Messages.Properties_Dialog_Label_Size;
    private static final String LAST_TITLE = Messages.Properties_Dialog_Label_Last_Modified;

    public FileEntryPropertyInfoPage(FileEntry fileEntry) {
        this.fileEntry = fileEntry;
        this.createContent();
    }

    private void createContent() {
        this.borderPane = new BorderPane();
        VBox vbox = new VBox();
        vbox.setPadding(new Insets(10.0));
        vbox.setSpacing(8.0);
        HBox pathHbox = new HBox();
        pathHbox.setAlignment(Pos.CENTER_LEFT);
        pathHbox.setPadding(new Insets(15.0, 12.0, 0.0, 12.0));
        pathHbox.setSpacing(10.0);
        Label pathLabel = new Label(PATH_TITLE);
        pathLabel.setMinWidth(80.0);
        Label pathValueLabel = new Label(this.fileEntry.getFullPath());
        pathValueLabel.setMinWidth(300.0);
        pathHbox.getChildren().addAll((Object[])new Node[]{pathLabel, pathValueLabel});
        HBox typeHbox = new HBox();
        typeHbox.setAlignment(Pos.CENTER_LEFT);
        typeHbox.setPadding(new Insets(15.0, 12.0, 0.0, 12.0));
        typeHbox.setSpacing(10.0);
        Label typeLabel = new Label(TYPE_TITLE);
        typeLabel.setMinWidth(80.0);
        Label typeValueLabel = new Label(this.fileEntry.getType().toString());
        typeValueLabel.setMinWidth(80.0);
        typeHbox.getChildren().addAll((Object[])new Node[]{typeLabel, typeValueLabel});
        HBox sizeHbox = new HBox();
        sizeHbox.setAlignment(Pos.CENTER_LEFT);
        sizeHbox.setPadding(new Insets(15.0, 12.0, 0.0, 12.0));
        sizeHbox.setSpacing(10.0);
        Label sizeLabel = new Label(SIZE_TITLE);
        sizeLabel.setMinWidth(80.0);
        Label sizeValueLabel = new Label(this.fileEntry.getSize() + " bytes");
        sizeValueLabel.setMinWidth(80.0);
        sizeHbox.getChildren().addAll((Object[])new Node[]{sizeLabel, sizeValueLabel});
        HBox lastHbox = new HBox();
        lastHbox.setAlignment(Pos.CENTER_LEFT);
        lastHbox.setPadding(new Insets(15.0, 12.0, 15.0, 12.0));
        lastHbox.setSpacing(10.0);
        Label lastLabel = new Label(LAST_TITLE);
        lastLabel.setMinWidth(80.0);
        Label lastValueLabel = new Label(this.fileEntry.getDate() + " " + this.fileEntry.getTime());
        lastValueLabel.setMinWidth(150.0);
        lastHbox.getChildren().addAll((Object[])new Node[]{lastLabel, lastValueLabel});
        HBox separatorHbox = new HBox();
        separatorHbox.setAlignment(Pos.CENTER_LEFT);
        separatorHbox.setPadding(new Insets(0.0, 12.0, 0.0, 12.0));
        separatorHbox.setSpacing(10.0);
        Separator separator = new Separator();
        separator.setOrientation(Orientation.HORIZONTAL);
        separator.setMinWidth(450.0);
        separatorHbox.getChildren().addAll((Object[])new Node[]{separator});
        vbox.getChildren().addAll((Object[])new Node[]{pathHbox, typeHbox, sizeHbox, lastHbox, separatorHbox});
        this.borderPane.getChildren().add((Object)vbox);
    }

    @Override
    public Node getNode() {
        return this.borderPane;
    }

    @Override
    public String getTitle() {
        return "Info";
    }

    @Override
    public String getDescription() {
        return "Info";
    }
}

