/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.device.manager.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import org.tizen.device.manager.InstallDeviceInfo;
import org.tizen.device.manager.StringResources;
import org.tizen.device.manager.logging.DeviceLogger;

public class AboutPageInfo {
    private static AboutPageInfo about = null;
    private String version = "";
    private String about_version = "";
    private String time = "";
    private String gitVersion = "";
    private String packageVersion = "";
    private String workspace = InstallDeviceInfo.getDeviceDataPath();
    private String contents = "";

    public static AboutPageInfo getInstance() {
        if (about == null) {
            about = new AboutPageInfo();
        }
        return about;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AboutPageInfo() {
        InputStream in = this.getClass().getClassLoader().getResourceAsStream("about.properties");
        Properties properties = new Properties();
        String ver = null;
        if (in != null) {
            try {
                properties.load(in);
                this.time = properties.getProperty("build_time");
                this.gitVersion = properties.getProperty("build_git_commit");
                this.packageVersion = properties.getProperty("package_version");
            }
            catch (IOException e1) {
                DeviceLogger.getLogger().log(Level.SEVERE, e1.getMessage());
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    DeviceLogger.getLogger().log(Level.SEVERE, e.getMessage());
                }
            }
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(InstallDeviceInfo.getTizenSDKPath() + File.separator + "sdk.version");
            Properties props = new Properties();
            props.load(fis);
            ver = props.getProperty("TIZEN_SDK_VERSION");
        }
        catch (FileNotFoundException e) {
            DeviceLogger.getLogger().log(Level.SEVERE, e.getMessage());
        }
        catch (Exception e) {
            DeviceLogger.getLogger().log(Level.SEVERE, e.getMessage());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    DeviceLogger.getLogger().log(Level.SEVERE, e.getMessage());
                }
            }
        }
        if (ver == null) {
            this.about_version = "undefined";
            this.version = "undefined";
        } else if (ver.indexOf(40) == -1) {
            this.about_version = this.version = ver;
        } else {
            int start = ver.indexOf(40);
            int end = ver.indexOf(41);
            this.version = ver.substring(0, start);
            this.about_version = ver.substring(start + 1, end);
        }
        if (this.time.isEmpty() || this.time.contains("build_time")) {
            this.time = "undefined";
        }
        if (this.gitVersion.isEmpty() || this.gitVersion.contains("build_git_commit")) {
            this.gitVersion = "undefined";
        }
        if (this.workspace.isEmpty()) {
            this.workspace = "undefined";
        }
        if (this.packageVersion == null || this.packageVersion.isEmpty()) {
            this.packageVersion = "undefined";
        }
        this.contents = "Version: " + this.about_version + StringResources.NEW_LINE + "Build time: " + this.time + " (GMT)" + StringResources.NEW_LINE + "Git version: " + this.gitVersion + StringResources.NEW_LINE + "Workspace path: " + this.workspace + StringResources.NEW_LINE + "Package version: " + this.packageVersion;
    }

    public String getVersion() {
        return this.version;
    }

    public String getBuildTime() {
        return this.time;
    }

    public String getGitVersion() {
        return this.gitVersion;
    }

    public String getWorkspacePath() {
        return this.workspace;
    }

    public String getAboutVersion() {
        return this.about_version;
    }

    public String getPackageVersion() {
        return this.packageVersion;
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }
}

