#!/bin/sh

## User Define for desktop menu
desktoppath=~/.local/share/applications

## Do not modify the followings (Make desktop menu)
TIZEN_SDK_INSTALL_PATH=${INSTALLED_PATH}
if [ -z "$TIZEN_SDK_INSTALL_PATH" ]
then
   exit 2;
fi

## em shortcut
device_desktopfile=${desktoppath}/tizen-studio-devicemanager.desktop
device_iconfile=device_manager.ico
device_iconpath=${TIZEN_SDK_INSTALL_PATH}/tools/device-manager/icons
device_exefile=tools/device-manager/bin/device-manager
device_exepath=${TIZEN_SDK_INSTALL_PATH}/$device_exefile
device_comment="Device manager of Tizen Studio is a tool which controls connected device and log view."
device_name="Device Manager"

if [ -e "${MAKESHORTCUT_PATH}" ]
then
	"${MAKESHORTCUT_PATH}" \
		-f "${device_desktopfile}" \
		-e "${device_exepath}" \
		-i "${device_iconpath}/$device_iconfile" \
		-n "${device_name}" \
		-c "${device_comment}"
else
	echo ${MAKESHORTCUT_PATH} does not exist
fi

## make $USERNAME.lock file
echo ${SDK_DATA_PATH} > "${TIZEN_SDK_INSTALL_PATH}/tools/device-manager/bin/.$USER.lock"
exit 0
