/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalysis.ide.eplugin.launch;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.launch.internal.ui.LaunchMessages;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.tizen.nativecommon.launch.ui.TizenMainTab;

public class TizenNativeApplicationDAMainTab
extends TizenMainTab {
    protected void updateProgramFromConfig(ILaunchConfiguration config) {
        if (this.fProgText != null) {
            String programName = "";
            try {
                if (!TizenNativeApplicationDAMainTab.isUnitTestProject(config)) {
                    programName = config.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "");
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            this.fProgText.setText(programName);
        }
    }

    protected void updateProjectFromConfig(ILaunchConfiguration config) {
        String projectName = "";
        String configName = "";
        try {
            if (!TizenNativeApplicationDAMainTab.isUnitTestProject(config)) {
                projectName = config.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
                configName = config.getAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", "");
            }
        }
        catch (CoreException ce) {
            LaunchUIPlugin.log((Throwable)ce);
        }
        if (!this.fProjText.getText().equals(projectName)) {
            this.fProjText.setText(projectName);
        }
        this.updateBuildConfigCombo(configName);
    }

    protected ICProject chooseCProject() {
        try {
            ICProject[] projects = this.getCProjects();
            ArrayList<ICProject> filteredProjects = new ArrayList<ICProject>();
            ICProject[] iCProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                ICProject project = iCProjectArray[n2];
                String[] natures = project.getProject().getDescription().getNatureIds();
                boolean isUnittestProject = false;
                String[] stringArray = natures;
                int n3 = natures.length;
                int n4 = 0;
                while (n4 < n3) {
                    String nature = stringArray[n4];
                    if (nature.equals("org.tizen.tizentest.nature")) {
                        isUnittestProject = true;
                        break;
                    }
                    ++n4;
                }
                if (!isUnittestProject) {
                    filteredProjects.add(project);
                }
                ++n2;
            }
            CElementLabelProvider labelProvider = new CElementLabelProvider();
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
            dialog.setTitle(LaunchMessages.CMainTab_Project_Selection);
            dialog.setMessage(LaunchMessages.CMainTab_Choose_project_to_constrain_search_for_program);
            dialog.setElements(filteredProjects.toArray());
            ICProject cProject = this.getCProject();
            if (cProject != null) {
                dialog.setInitialSelections(new Object[]{cProject});
            }
            if (dialog.open() == 0) {
                return (ICProject)dialog.getFirstResult();
            }
        }
        catch (CModelException e) {
            LaunchUIPlugin.errorDialog((String)"Launch UI internal error", (Throwable)e);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isUnitTestProject(ILaunchConfiguration config) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        try {
            String[] natures;
            String pName = config.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
            if (pName.equals("")) return false;
            String[] stringArray = natures = root.getProject(pName).getDescription().getNatureIds();
            int n = natures.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                String nature = stringArray[n2];
                if (nature.equals("org.tizen.tizentest.nature")) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            return false;
        }
    }
}

