/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.communicator;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.tizen.common.core.application.ProfileInfo;
import org.tizen.dynamicanalyzer.communicator.BaseCommunicator;
import org.tizen.dynamicanalyzer.project.AppInfo;
import org.tizen.dynamicanalyzer.project.DeviceStatusInfo;
import org.tizen.dynamicanalyzer.project.PackageInfo;
import org.tizen.dynamicanalyzer.ui.info.screenshot.EmulatorScreenshot;
import org.tizen.sdblib.IDevice;

public class DeviceInfo {
    private IDevice device = null;
    private BaseCommunicator communicator = null;
    private boolean configSuccess = false;
    private Map<String, PackageInfo> pkgInfoMap = new HashMap<String, PackageInfo>();
    private Map<String, AppInfo> appInfoMap = new TreeMap<String, AppInfo>();
    private DeviceStatusInfo statusInfo = null;
    private String profileName = null;
    private boolean availabilityOfRoot = false;
    private boolean availableMemps = false;
    private boolean isNoRootSwapInstalled = false;
    public EmulatorScreenshot emulatorScreenshot = null;

    public DeviceInfo(IDevice device) {
        this.device = device;
        this.communicator = new BaseCommunicator(this);
        this.statusInfo = new DeviceStatusInfo();
        this.availableMemps = false;
    }

    public IDevice getIDevice() {
        return this.device;
    }

    public boolean isSameDevice(DeviceInfo target) {
        return this.device.getSerialNumber().equals(target.getIDevice().getSerialNumber());
    }

    public DeviceStatusInfo getDeviceStatusInfo() {
        return this.statusInfo;
    }

    public boolean isNoRootSwapInstalled() {
        return this.isNoRootSwapInstalled;
    }

    public void setNoRootSwapInstalled(boolean isNewSwapInstalled) {
        this.isNoRootSwapInstalled = isNewSwapInstalled;
    }

    public BaseCommunicator getCommunicator() {
        return this.communicator;
    }

    public Map<String, PackageInfo> getPackageInfoMap() {
        return this.pkgInfoMap;
    }

    public Map<String, AppInfo> getAppInfoMap() {
        return this.appInfoMap;
    }

    public String getPlatformName() {
        if (this.profileName == null) {
            ProfileInfo profile = ProfileInfo.getProfileInfo((IDevice)this.device);
            if (profile != null) {
                this.profileName = profile.getProfile();
            }
            if (this.profileName == null) {
                this.profileName = "";
            }
        }
        return this.profileName;
    }

    public boolean isEmulator() {
        return this.device != null && this.device.getSerialNumber().contains("emulator");
    }

    public boolean isConfigSuccess() {
        return this.configSuccess;
    }

    public void setConfigSuccess(boolean success) {
        this.configSuccess = success;
    }

    public boolean isRootAvailable() {
        return this.availabilityOfRoot;
    }

    public void setAvailabilityOfRoot(boolean availability) {
        this.availabilityOfRoot = availability;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAppMap() {
        Map<String, PackageInfo> map = this.pkgInfoMap;
        synchronized (map) {
            this.appInfoMap.clear();
            for (Map.Entry<String, PackageInfo> entry : this.pkgInfoMap.entrySet()) {
                for (AppInfo app : entry.getValue().getAppInfos()) {
                    this.appInfoMap.put(app.getAppID(), app);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePackageList(Map<String, PackageInfo> newPackages) {
        PackageInfo oldpkg;
        boolean needUpdate = false;
        Map<String, PackageInfo> map = this.pkgInfoMap;
        synchronized (map) {
            Iterator<Map.Entry<String, PackageInfo>> iter = this.pkgInfoMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, PackageInfo> entry = iter.next();
                String pkgid = entry.getKey();
                oldpkg = entry.getValue();
                PackageInfo newpkg = newPackages.get(pkgid);
                if (newpkg == null) {
                    iter.remove();
                    needUpdate = true;
                    continue;
                }
                if (oldpkg.getInstallTime() == newpkg.getInstallTime()) continue;
                entry.setValue(newpkg);
                needUpdate = true;
            }
        }
        for (Map.Entry<String, PackageInfo> entry : newPackages.entrySet()) {
            String pkgid = entry.getKey();
            PackageInfo newpkg = entry.getValue();
            oldpkg = this.pkgInfoMap.get(pkgid);
            if (oldpkg != null) continue;
            Map<String, PackageInfo> map2 = this.pkgInfoMap;
            synchronized (map2) {
                this.pkgInfoMap.put(pkgid, newpkg);
                needUpdate = true;
            }
        }
        if (needUpdate) {
            this.updateAppMap();
        }
    }

    public PackageInfo getPkgInfoByPkgID(String pkgid) {
        return this.pkgInfoMap.get(pkgid);
    }

    public PackageInfo getPkgInfoByAppID(String appid) {
        for (Map.Entry<String, PackageInfo> entry : this.pkgInfoMap.entrySet()) {
            PackageInfo aPkg = entry.getValue();
            for (AppInfo anApp : aPkg.getAppInfos()) {
                if (!anApp.getAppID().equals(appid)) continue;
                return aPkg;
            }
        }
        return null;
    }

    public AppInfo getAppInfoByAppID(String appID) {
        for (Map.Entry<String, PackageInfo> entry : this.pkgInfoMap.entrySet()) {
            PackageInfo aPkg = entry.getValue();
            for (AppInfo anApp : aPkg.getAppInfos()) {
                if (!anApp.getAppID().equals(appID)) continue;
                return anApp;
            }
        }
        return null;
    }

    public void setMempAvailable(boolean enable) {
        this.availableMemps = enable;
    }

    public boolean getMempAvailable() {
        return this.availableMemps;
    }
}

