/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.communicator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.common.DAResult;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.common.path.PathManager;
import org.tizen.dynamicanalyzer.communicator.CommunicatorUtils;
import org.tizen.dynamicanalyzer.communicator.DeviceInfo;
import org.tizen.dynamicanalyzer.communicator.IDeviceStatusListener;
import org.tizen.dynamicanalyzer.handlers.UIActionHolder;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.protocol.Protocol;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.ui.notification.NotificationManager;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IDeviceChangeListener;
import org.tizen.sdblib.SmartDevelopmentBridge;
import org.tizen.sdblib.util.DeviceUtil;

public class DeviceManager {
    private static SmartDevelopmentBridge sdbBridge = null;
    private static List<DeviceInfo> devices = Collections.synchronizedList(new ArrayList());
    private static Set<IDeviceStatusListener> listeners = new HashSet<IDeviceStatusListener>();
    private static IDeviceChangeListener deviceChanged = new IDeviceChangeListener(){

        public void onDisconnected(IDevice device) {
            Logger.debug((Object)("device disconnected : " + device.getSerialNumber()));
            if (DeviceManager.onDisconnectedInternal(device)) {
                DeviceManager.notifyListeners(false, device);
            }
        }

        public void onConnected(IDevice device) {
            Logger.debug((Object)("device connected : " + device.getSerialNumber()));
            if (DeviceManager.onConnectedInternal(device)) {
                DeviceManager.notifyListeners(true, device);
            }
        }

        public void onChanged(IDevice device, int changeMask) {
            Logger.debug((Object)("device changed : " + device.getSerialNumber() + " : " + changeMask));
            if (changeMask == 1 || changeMask == 7) {
                boolean bRemoved = DeviceManager.onDisconnectedInternal(device);
                boolean bAdded = DeviceManager.onConnectedInternal(device);
                if (bRemoved) {
                    DeviceManager.notifyListeners(false, device);
                } else if (bAdded) {
                    DeviceManager.notifyListeners(true, device);
                }
            }
        }
    };

    public static void init() {
        if (PathManager.SDB_PATH != null) {
            sdbBridge = SmartDevelopmentBridge.createBridge((String)PathManager.SDB_PATH);
            sdbBridge.startBridge();
            sdbBridge.waitforStart();
        }
        if (Global.isGUIMode()) {
            listeners.add(DeviceManager::updateUIByDevice);
        }
    }

    private static boolean onDisconnectedInternal(IDevice device) {
        boolean bRemoved = false;
        DeviceInfo deviceInfo = DeviceManager.getDeviceByName(device.getSerialNumber());
        if (deviceInfo != null) {
            bRemoved = devices.remove(deviceInfo);
            deviceInfo.getCommunicator().disconnect();
        }
        return bRemoved;
    }

    private static boolean onConnectedInternal(IDevice device) {
        DAResult result;
        DeviceInfo devInfo = new DeviceInfo(device);
        for (DeviceInfo dinfo : devices) {
            if (!dinfo.isSameDevice(devInfo)) continue;
            return true;
        }
        if (SettingDataManager.INSTANCE.isPlatformDA()) {
            devInfo.setAvailabilityOfRoot(CommunicatorUtils.enableRoot(device));
        }
        if ((result = devInfo.getCommunicator().connect()).isSuccess()) {
            double versionNum;
            String devProtocol = devInfo.getCommunicator().getProtocolVersion();
            if (devProtocol != null && (versionNum = Protocol.getVersion(devProtocol).getVersionNum()) >= Protocol.VERSION_42.getVersionNum()) {
                Logger.debug((Object)"set Memps Available");
                devInfo.setMempAvailable(true);
            }
            devices.add(devInfo);
            return true;
        }
        String errMsg = result.equals(new DAResult(DAResult.ErrorCode.ERR_NOT_SUPPORTED)) ? "Cannot found some components: " : "Cannot connect with swap manager: ";
        Logger.warning((Object)(String.valueOf(errMsg) + result.getMessage()));
        result.setDetailMessage(String.valueOf(devInfo.getIDevice().getDeviceName()) + ", " + devInfo.getIDevice().getSerialNumber());
        UIActionHolder.getUIAction().showWarning(result);
        return false;
    }

    private static void updateUIByDevice(boolean connected, IDevice device) {
        Display.getDefault().asyncExec(() -> Toolbar.INSTANCE.updateDeviceCombo(null));
        String title = connected ? AnalyzerLabels.NOTIFICATION_DEVICE_CONNECTED : AnalyzerLabels.NOTIFICATION_DEVICE_DISCONNECTED;
        String message = device.getDeviceName();
        String details = device.getSerialNumber();
        NotificationManager.showNotification(title, message, details);
    }

    public static void addDeviceListener() {
        SmartDevelopmentBridge.addDeviceChangeListener((IDeviceChangeListener)deviceChanged);
    }

    public static void removeDeviceListener() {
        SmartDevelopmentBridge.removeDeviceChangeListener((IDeviceChangeListener)deviceChanged);
    }

    public static void loadDevices() {
        if (sdbBridge == null) {
            Logger.warning((Object)"sdbbridge is null!");
            return;
        }
        IDevice[] iDeviceArray = sdbBridge.getDevices();
        int n = iDeviceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDevice device = iDeviceArray[n2];
            if (DeviceUtil.isOnline((IDevice)device)) {
                DeviceManager.onConnectedInternal(device);
            }
            ++n2;
        }
    }

    public static List<DeviceInfo> getDevicesOnSdb() {
        ArrayList<DeviceInfo> sdbDevices = new ArrayList<DeviceInfo>();
        if (sdbBridge == null) {
            Logger.warning((Object)"sdbbridge is null!");
            return sdbDevices;
        }
        IDevice[] iDeviceArray = sdbBridge.getDevices();
        int n = iDeviceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDevice device = iDeviceArray[n2];
            if (DeviceUtil.isOnline((IDevice)device)) {
                sdbDevices.add(new DeviceInfo(device));
            }
            ++n2;
        }
        return sdbDevices;
    }

    public static List<DeviceInfo> getDevices() {
        return Collections.unmodifiableList(devices);
    }

    public static DeviceInfo getDeviceByName(String name) {
        for (DeviceInfo device : devices) {
            if (!device.getIDevice().getSerialNumber().equals(name)) continue;
            return device;
        }
        return null;
    }

    public static boolean isDeviceConnected() {
        return !devices.isEmpty();
    }

    public static boolean onDeviceSelected(String serial) {
        if (serial == null || serial.isEmpty()) {
            Global.setCurrentDeviceInfo(null);
            return true;
        }
        for (DeviceInfo device : devices) {
            if (!serial.equals(device.getIDevice().getSerialNumber())) continue;
            Global.setCurrentDeviceInfo(device);
            return true;
        }
        return false;
    }

    public static void closeAll() {
        for (DeviceInfo device : devices) {
            device.getCommunicator().disconnect();
        }
    }

    public static void addDeviceStatusListener(IDeviceStatusListener listener) {
        listeners.add(listener);
    }

    public static void removeDeviceStatusListener(IDeviceStatusListener listener) {
        listeners.remove(listener);
    }

    private static void notifyListeners(boolean connected, IDevice device) {
        for (IDeviceStatusListener listener : listeners) {
            listener.onStatusChanged(connected, device);
        }
    }
}

