/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.swap.logparser;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.tizen.dynamicanalyzer.swap.logparser.LogPackage;
import org.tizen.dynamicanalyzer.swap.logparser.PageDataManager;
import org.tizen.dynamicanalyzer.ui.page.PageInfoRegistry;
import org.tizen.dynamicanalyzer.util.Logger;

public class DataManagerRegistry {
    private static Map<String, PageDataManager> dataManagers = null;

    static {
        dataManagers = new HashMap<String, PageDataManager>();
    }

    public static synchronized void registerPageDataManager(PageDataManager mgr) {
        if (!dataManagers.containsKey(mgr.getName())) {
            dataManagers.put(mgr.getName(), mgr);
            Logger.debug((Object)("Registered PageDataManager: " + mgr));
        }
    }

    public static void createDataManagers(String pageName) {
        Set<PageDataManager> managers = PageInfoRegistry.getUnregisteredDataManagers(pageName, dataManagers);
        for (PageDataManager mgr : managers) {
            DataManagerRegistry.registerPageDataManager(mgr);
        }
    }

    public static void createDataManagers(Set<String> pageNames) {
        for (String pageName : pageNames) {
            DataManagerRegistry.createDataManagers(pageName);
        }
    }

    public static void createDataManagersByTarget(String targetName) {
        DataManagerRegistry.createDataManagers(PageInfoRegistry.getPageNamesByTarget(targetName));
    }

    public static Set<Map.Entry<String, PageDataManager>> getEntrySet() {
        return dataManagers.entrySet();
    }

    public static void startThreads() {
        for (Map.Entry<String, PageDataManager> entry : dataManagers.entrySet()) {
            entry.getValue().start();
        }
    }

    public static void stopThreadsNormal() {
        for (Map.Entry<String, PageDataManager> entry : dataManagers.entrySet()) {
            entry.getValue().stopNormal();
        }
    }

    public static void stopThreadsForced() {
        for (Map.Entry<String, PageDataManager> entry : dataManagers.entrySet()) {
            entry.getValue().stopForced();
        }
    }

    public static boolean isAnyoneAlive() {
        boolean ret = false;
        for (Map.Entry<String, PageDataManager> entry : dataManagers.entrySet()) {
            ret = entry.getValue().isThreadAlive();
            if (ret) break;
        }
        return ret;
    }

    public static void updateLog(LogPackage pack) {
        for (Map.Entry<String, PageDataManager> entry : dataManagers.entrySet()) {
            entry.getValue().pushData(pack);
        }
    }

    public static void saveData() {
        for (Map.Entry<String, PageDataManager> entry : dataManagers.entrySet()) {
            entry.getValue().saveData(null);
        }
    }

    public static void openData() {
        for (Map.Entry<String, PageDataManager> entry : dataManagers.entrySet()) {
            entry.getValue().openData(null);
        }
    }
}

