/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.swap.model.data;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.communicator.ProtocolParser;
import org.tizen.dynamicanalyzer.communicator.UnsupportedProtocolException;
import org.tizen.dynamicanalyzer.model.DATime;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.HierarchyUIObject;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.HierarchyUIObjectProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.UIObjectCategoryCode;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.edje.EdjeProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary.ElementaryProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary.ElmBackgroundProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary.ElmButtonProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary.ElmCheckProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary.ElmColorselectorProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary.ElmCtxpopupProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary.ElmDatetimeProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary.ElmEntryProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary.ElmFlipProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary.ElmGengridProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary.ElmGenlistProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary.ElmGlviewProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary.ElmIconProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary.ElmImageProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary.ElmIndexProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary.ElmLabelProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary.ElmListProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary.ElmMapProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary.ElmNotifyProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary.ElmPanelProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary.ElmPhotoProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary.ElmPhotocamProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary.ElmPopupProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary.ElmProgressbarProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary.ElmRadioProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary.ElmSegmentcontrolProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary.ElmSliderProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary.ElmSpinnerProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary.ElmToolbarProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary.ElmTooltipProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary.ElmWinProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.evas.EvasBoxProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.evas.EvasGridProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.evas.EvasImageProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.evas.EvasLineProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.evas.EvasProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.evas.EvasTableProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.evas.EvasTextProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.evas.EvasTextblockProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.evas.EvasTextgridProperties;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.DownloadContentfileManager;

public class UIHierarchyData
extends LogData {
    String filePath;

    @Override
    public UIHierarchyData clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    protected boolean parse(DATime startTime) {
        super.parse(startTime);
        this.filePath = this.getString();
        return true;
    }

    public boolean lazyParse(List<HierarchyUIObject> rootUIObjects) {
        if (this.filePath != null) {
            String to = String.valueOf(Global.getProject().getSavePath()) + File.separator + "img" + File.separator + "ui_hierarchy";
            if (DownloadContentfileManager.pullFile(this.filePath, to)) {
                return this.extractUIHierarchyInfo(rootUIObjects);
            }
            Logger.error((Object)"UI Hierarchy file couldn't be downloaded!");
        }
        return false;
    }

    public String getFilePath() throws UnsupportedProtocolException {
        switch (this.protocolVersion) {
            case VERSION_30: 
            case VERSION_30A: 
            case VERSION_40: {
                throw new UnsupportedProtocolException();
            }
        }
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public boolean extractUIHierarchyInfo(List<HierarchyUIObject> rootUIObjects) {
        rootUIObjects.clear();
        String hierarchyInfoFilePath = String.valueOf(Global.getProject().getSavePath()) + File.separator + "img" + File.separator + "ui_hierarchy";
        File hierarchyInfoFile = new File(hierarchyInfoFilePath);
        if (!hierarchyInfoFile.exists()) {
            Logger.debug((Object)("No hierarchy path : " + hierarchyInfoFilePath));
            return false;
        }
        try {
            byte[] data = Files.readAllBytes(new File(hierarchyInfoFilePath).toPath());
            ProtocolParser parser = new ProtocolParser(data);
            char requestOption = parser.getChar();
            int count = parser.getInt();
            PriorityQueue<HierarchyUIObject> queue = new PriorityQueue<HierarchyUIObject>();
            ArrayList<HierarchyUIObject> uiObjects = new ArrayList<HierarchyUIObject>();
            int i = 0;
            while (i < count) {
                HierarchyUIObject uiObject = new HierarchyUIObject();
                uiObject.setAddress(parser.getLong());
                uiObject.setCategory(UIObjectCategoryCode.getCategoryCode(parser.getChar()));
                uiObject.setTypeCode(parser.getInt());
                uiObject.setTypeName(parser.getString());
                uiObject.setRenderTime(parser.getInt(), parser.getInt());
                uiObject.setParentAddress(parser.getLong());
                this.parseProperties(uiObject, parser);
                uiObjects.add(uiObject);
                if (requestOption == '\u0002' && uiObject.getCategory() == UIObjectCategoryCode.ELEMENTARY || requestOption == '\u0001' && uiObject.getCategory() != UIObjectCategoryCode.EDJE) {
                    queue.add(uiObject);
                }
                ++i;
            }
            this.calculateRenderSpeedGrade(queue);
            if (requestOption == '\u0003' || requestOption == '\u0002') {
                return this.makeElementaryUIObjectRelation(uiObjects, rootUIObjects);
            }
            return this.makeUIObjectRelation(uiObjects, rootUIObjects);
        }
        catch (IOException e) {
            Logger.exception((Throwable)e);
            return false;
        }
    }

    private boolean makeUIObjectRelation(List<HierarchyUIObject> uiObjects, List<HierarchyUIObject> rootUIObjects) {
        int i = 0;
        while (i < uiObjects.size()) {
            HierarchyUIObject uiObject = uiObjects.get(i);
            long parentAddress = uiObject.getParentAddress();
            if (parentAddress == 0L) {
                rootUIObjects.add(uiObject);
            } else {
                HierarchyUIObject parentUIObject = this.findHierarchyUIObject(parentAddress, uiObjects);
                if (parentUIObject == null) {
                    Logger.error((Object)"Hierarchy of UIObject is invalid!!");
                    return false;
                }
                if (!parentUIObject.addChildUIObject(uiObject)) {
                    Logger.error((Object)("There is a duplicated UIObject [" + uiObject.getAddress() + "]."));
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private boolean makeElementaryUIObjectRelation(List<HierarchyUIObject> uiObjects, List<HierarchyUIObject> rootUIObjects) {
        int i = 0;
        while (i < uiObjects.size()) {
            HierarchyUIObject uiObject = uiObjects.get(i);
            if (uiObject.getCategory() == UIObjectCategoryCode.ELEMENTARY) {
                long parentAddress = uiObject.getParentAddress();
                while (parentAddress != 0L) {
                    HierarchyUIObject parentUIObject = this.findHierarchyUIObject(parentAddress, uiObjects);
                    if (parentUIObject == null) {
                        Logger.error((Object)"Hierarchy of UIObject is invalid!!");
                        return false;
                    }
                    if (parentUIObject.getCategory() == UIObjectCategoryCode.ELEMENTARY) {
                        if (parentUIObject.addChildUIObject(uiObject)) break;
                        Logger.error((Object)("There is a duplicated UIObject [" + uiObject.getAddress() + "]."));
                        return false;
                    }
                    parentAddress = parentUIObject.getParentAddress();
                }
                if (parentAddress == 0L) {
                    rootUIObjects.add(uiObject);
                }
            }
            ++i;
        }
        return true;
    }

    private HierarchyUIObject findHierarchyUIObject(long address, List<HierarchyUIObject> uiObjects) {
        int i = 0;
        while (i < uiObjects.size()) {
            if (uiObjects.get(i).getAddress() == address) {
                return uiObjects.get(i);
            }
            ++i;
        }
        return null;
    }

    private void calculateRenderSpeedGrade(PriorityQueue<HierarchyUIObject> queue) {
        int size = queue.size();
        HierarchyUIObject cursor = null;
        int i = 0;
        while (i < size) {
            cursor = queue.poll();
            if (i < size / 2) {
                cursor.setRenderSpeedGrade(HierarchyUIObject.RENDER_SPEED_GRADE.FASTER);
            } else if (size / 2 <= i && i < size - 1) {
                cursor.setRenderSpeedGrade(HierarchyUIObject.RENDER_SPEED_GRADE.SLOWER);
            } else {
                cursor.setRenderSpeedGrade(HierarchyUIObject.RENDER_SPEED_GRADE.SLOWEST);
            }
            ++i;
        }
    }

    private boolean parseProperties(HierarchyUIObject uiObject, ProtocolParser parser) {
        EvasProperties evasProperties = new EvasProperties(this.protocolVersion);
        evasProperties.parsePropertiesFromByte(parser);
        uiObject.setEvasProperties(evasProperties);
        switch (uiObject.getCategory()) {
            case EVAS: {
                break;
            }
            case ELEMENTARY: {
                ElementaryProperties elementaryProperties = new ElementaryProperties(this.protocolVersion);
                elementaryProperties.parsePropertiesFromByte(parser);
                uiObject.setElementaryProperties(elementaryProperties);
                break;
            }
            case EDJE: {
                EdjeProperties edjeProperties = new EdjeProperties(this.protocolVersion);
                edjeProperties.parsePropertiesFromByte(parser);
                uiObject.setEdjeProperties(edjeProperties);
                break;
            }
            default: {
                Logger.error((Object)("Unsupported Object type : " + uiObject.getCategory().getCodeNumber()));
            }
        }
        HierarchyUIObjectProperties specificProperties = this.createSpecificProperties(uiObject.getTypeCode());
        if (specificProperties != null) {
            specificProperties.parsePropertiesFromByte(parser);
            uiObject.setSpecificProperties(specificProperties);
        }
        return true;
    }

    private HierarchyUIObjectProperties createSpecificProperties(int typeCode) {
        switch (typeCode) {
            case 257: {
                return new EvasImageProperties(this.protocolVersion);
            }
            case 258: {
                return new EvasLineProperties(this.protocolVersion);
            }
            case 259: {
                return null;
            }
            case 260: {
                return null;
            }
            case 261: {
                return new EvasTextProperties(this.protocolVersion);
            }
            case 262: {
                return new EvasTextblockProperties(this.protocolVersion);
            }
            case 263: {
                return null;
            }
            case 264: {
                return new EvasTableProperties(this.protocolVersion);
            }
            case 265: {
                return new EvasBoxProperties(this.protocolVersion);
            }
            case 266: {
                return new EvasGridProperties(this.protocolVersion);
            }
            case 267: {
                return new EvasTextgridProperties(this.protocolVersion);
            }
            case 268: {
                return null;
            }
            case 513: {
                return new ElmBackgroundProperties(this.protocolVersion);
            }
            case 514: {
                return new ElmButtonProperties(this.protocolVersion);
            }
            case 515: {
                return new ElmCheckProperties(this.protocolVersion);
            }
            case 516: {
                return new ElmColorselectorProperties(this.protocolVersion);
            }
            case 517: {
                return new ElmCtxpopupProperties(this.protocolVersion);
            }
            case 518: {
                return new ElmDatetimeProperties(this.protocolVersion);
            }
            case 519: {
                return new ElmEntryProperties(this.protocolVersion);
            }
            case 520: {
                return new ElmFlipProperties(this.protocolVersion);
            }
            case 521: {
                return new ElmGengridProperties(this.protocolVersion);
            }
            case 522: {
                return new ElmGenlistProperties(this.protocolVersion);
            }
            case 523: {
                return new ElmGlviewProperties(this.protocolVersion);
            }
            case 524: {
                return new ElmIconProperties(this.protocolVersion);
            }
            case 525: {
                return new ElmImageProperties(this.protocolVersion);
            }
            case 526: {
                return new ElmIndexProperties(this.protocolVersion);
            }
            case 527: {
                return new ElmLabelProperties(this.protocolVersion);
            }
            case 528: {
                return new ElmListProperties(this.protocolVersion);
            }
            case 529: {
                return new ElmMapProperties(this.protocolVersion);
            }
            case 530: {
                return new ElmNotifyProperties(this.protocolVersion);
            }
            case 531: {
                return new ElmPanelProperties(this.protocolVersion);
            }
            case 532: {
                return new ElmPhotoProperties(this.protocolVersion);
            }
            case 533: {
                return new ElmPhotocamProperties(this.protocolVersion);
            }
            case 534: {
                return null;
            }
            case 535: {
                return new ElmPopupProperties(this.protocolVersion);
            }
            case 536: {
                return new ElmProgressbarProperties(this.protocolVersion);
            }
            case 537: {
                return new ElmRadioProperties(this.protocolVersion);
            }
            case 538: {
                return new ElmSegmentcontrolProperties(this.protocolVersion);
            }
            case 539: {
                return new ElmSliderProperties(this.protocolVersion);
            }
            case 540: {
                return new ElmSpinnerProperties(this.protocolVersion);
            }
            case 541: {
                return new ElmToolbarProperties(this.protocolVersion);
            }
            case 542: {
                return new ElmTooltipProperties(this.protocolVersion);
            }
            case 543: {
                return new ElmWinProperties(this.protocolVersion);
            }
        }
        Logger.warning((Object)("Unsupported Object : " + typeCode));
        return null;
    }

    public static int getRequestOption(boolean onlyElementary, boolean requestRenderTime) {
        if (onlyElementary && requestRenderTime) {
            return 2;
        }
        if (onlyElementary && !requestRenderTime) {
            return 3;
        }
        if (!onlyElementary && requestRenderTime) {
            return 1;
        }
        return 0;
    }
}

