/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.swap.model.data.hierarchy;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.HierarchyUIObjectProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.PropertyValue;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.UIObjectCategoryCode;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.edje.EdjeProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary.ElementaryProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.evas.EvasProperties;

public class HierarchyUIObject
implements Comparable<HierarchyUIObject> {
    public static final long ROOT_PARENT_ADDRESS = 0L;
    private long address;
    private UIObjectCategoryCode category;
    private String typeName;
    private int typeCode;
    private long parentAddress;
    private double renderTime;
    private RENDER_SPEED_GRADE renderSpeedGrade = RENDER_SPEED_GRADE.NO_MEASURE;
    private String imageFileName;
    private EvasProperties evasProperties;
    private ElementaryProperties elementaryProperties;
    private EdjeProperties edjeProperties;
    private HierarchyUIObjectProperties specificProperties;
    private Set<HierarchyUIObject> children = new HashSet<HierarchyUIObject>();
    private STATUS status = STATUS.OK;

    public String getImageFilePath() {
        if (Global.getProject() != null && this.imageFileName != null) {
            return String.valueOf(Global.getProject().getSavePath()) + File.separator + "img" + File.separator + this.imageFileName;
        }
        return null;
    }

    public void setImageFile(String imageFileName) {
        this.imageFileName = imageFileName;
    }

    public void setAddress(long address) {
        this.address = address;
    }

    public long getAddress() {
        return this.address;
    }

    public void setCategory(UIObjectCategoryCode category) {
        this.category = category;
    }

    public UIObjectCategoryCode getCategory() {
        return this.category;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeCode(int typeCode) {
        this.typeCode = typeCode;
    }

    public int getTypeCode() {
        return this.typeCode;
    }

    public void setParentAddress(long parentAddress) {
        this.parentAddress = parentAddress;
    }

    public long getParentAddress() {
        return this.parentAddress;
    }

    public int[] getGeometry() {
        return this.evasProperties.getGeometry();
    }

    public void setRenderTime(int sec, int nano) {
        this.renderTime = (double)(sec * 1000) + (double)nano / 1000000.0;
    }

    public double getRenderTime() {
        return this.renderTime;
    }

    public RENDER_SPEED_GRADE getRenderSpeedGrade() {
        return this.renderSpeedGrade;
    }

    public void setRenderSpeedGrade(RENDER_SPEED_GRADE renderSpeedGrade) {
        this.renderSpeedGrade = renderSpeedGrade;
    }

    public String getName() {
        return this.evasProperties.getName();
    }

    public String getText() {
        String text = null;
        if (this.specificProperties != null) {
            text = this.specificProperties.getText();
        }
        if (text == null && this.elementaryProperties != null) {
            text = this.elementaryProperties.getText();
        }
        return text;
    }

    public List<PropertyValue> getUIObjectInfos() {
        ArrayList<PropertyValue> uiObjectInfos = new ArrayList<PropertyValue>();
        uiObjectInfos.add(new PropertyValue("address", "0x" + Long.toHexString(this.address)));
        uiObjectInfos.add(new PropertyValue("type", this.category.getName()));
        uiObjectInfos.add(new PropertyValue("typeName", this.typeName));
        return uiObjectInfos;
    }

    public List<PropertyValue> getEvasPropertiesValue() {
        if (this.evasProperties != null) {
            return this.evasProperties.getProperties();
        }
        return null;
    }

    public void setEvasProperties(EvasProperties evasProperties) {
        this.evasProperties = evasProperties;
    }

    public List<PropertyValue> getElementaryPropertiesValue() {
        if (this.elementaryProperties != null) {
            return this.elementaryProperties.getProperties();
        }
        return null;
    }

    public void setElementaryProperties(ElementaryProperties elementaryProperties) {
        this.elementaryProperties = elementaryProperties;
    }

    public List<PropertyValue> getEdjePropertiesValue() {
        if (this.edjeProperties != null) {
            return this.edjeProperties.getProperties();
        }
        return null;
    }

    public void setEdjeProperties(EdjeProperties edjeProperties) {
        this.edjeProperties = edjeProperties;
    }

    public List<PropertyValue> getSpecificPropertiesValue() {
        if (this.specificProperties != null) {
            return this.specificProperties.getProperties();
        }
        return null;
    }

    public void setSpecificProperties(HierarchyUIObjectProperties specificProperties) {
        this.specificProperties = specificProperties;
    }

    public boolean addChildUIObject(HierarchyUIObject child) {
        return this.children.add(child);
    }

    public Iterator<HierarchyUIObject> getChildrenIterator() {
        return this.children.iterator();
    }

    public int getNumberOfChildren() {
        return this.children.size();
    }

    public void setStatus(STATUS status) {
        this.status = status;
    }

    public STATUS getStatus() {
        return this.status;
    }

    public String getStatusMsg() {
        switch (this.status) {
            case APP_BACKGROUND: {
                return "App In Background";
            }
            case OBJECT_NOT_EXIST: {
                return "No Object";
            }
            case NO_IMAGE: {
                return "No Image";
            }
            case NOT_IN_TRACE: {
                return "Not In Tracing";
            }
            case ERROR: {
                return "Error";
            }
        }
        return "Normal";
    }

    @Override
    public int compareTo(HierarchyUIObject other) {
        if (this.renderTime > other.renderTime) {
            return 1;
        }
        if (this.renderTime < other.renderTime) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return "[" + this.address + ", " + (Object)((Object)this.category) + ", " + this.typeName + ", " + this.typeCode + ", " + this.getRenderTime() + "ms, " + this.renderSpeedGrade.name() + ", " + this.parentAddress + "]";
    }

    public boolean checkNeedToRequest() {
        int[] geometry = this.getGeometry();
        if (geometry[2] <= 0 || geometry[3] <= 0) {
            this.setStatus(STATUS.NO_IMAGE);
            return false;
        }
        return true;
    }

    public static enum RENDER_SPEED_GRADE {
        FASTER,
        SLOWER,
        SLOWEST,
        NO_MEASURE;

    }

    public static enum STATUS {
        OK,
        APP_BACKGROUND,
        OBJECT_NOT_EXIST,
        NO_IMAGE,
        NOT_IN_TRACE,
        ERROR;

    }
}

