/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.communicator.ProtocolParser;
import org.tizen.dynamicanalyzer.protocol.Protocol;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.HierarchyUIObjectProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.PropertyValue;
import org.tizen.dynamicanalyzer.util.Logger;

public class ElmLabelProperties
extends HierarchyUIObjectProperties {
    private int wrapWidth;
    private double slideSpeed;
    private String slideMode;

    public ElmLabelProperties(Protocol protocolVersion) {
        super(protocolVersion);
    }

    @Override
    public void parsePropertiesFromByte(ProtocolParser parser) {
        this.wrapWidth = parser.getInt();
        if (this.protocolVersion != Protocol.VERSION_30_UIHV) {
            this.slideSpeed = parser.getFloat();
        }
        this.slideMode = this.getSlideModeMessage(parser.getChar());
    }

    @Override
    public List<PropertyValue> getProperties() {
        ArrayList<PropertyValue> properties = new ArrayList<PropertyValue>();
        properties.add(new PropertyValue("wrapWidth", Integer.toString(this.wrapWidth)));
        if (this.protocolVersion != Protocol.VERSION_30_UIHV) {
            properties.add(new PropertyValue("slideSpeed", Double.toString(this.slideSpeed)));
        }
        properties.add(new PropertyValue("slideMode", this.slideMode));
        return properties;
    }

    private String getSlideModeMessage(int code) {
        switch (code) {
            case 0: {
                return "ELM_LABEL_SLIDE_MODE_NONE";
            }
            case 1: {
                return "ELM_LABEL_SLIDE_MODE_AUTO";
            }
            case 2: {
                return "ELM_LABEL_SLIDE_MODE_ALWAYS";
            }
        }
        Logger.warning((Object)("Invalid code : " + code));
        return "-";
    }
}

