/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.file.data;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.database.SqlConnectionManager;
import org.tizen.dynamicanalyzer.ui.file.model.FileStatus;
import org.tizen.dynamicanalyzer.util.Logger;

public class FileStatusDB
extends DBTable {
    public static final String TABLENAME = "FILE_STATUS";
    private static final String selectAll = FileStatusDB.selectAll();
    private static final String SELECT_QUERY = "select " + selectAll + " from " + "FILE_STATUS";

    public FileStatusDB() {
        this.addColumn(new DBColumn(COLUMN.FILE_ID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.API_TYPE.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.EVENT_TIME.name, "NOT NULL", "BIGINT"));
    }

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public List<FileStatus> executeQueryRS(String query) {
        ArrayList<FileStatus> resultData = new ArrayList<FileStatus>();
        ResultSet rs = SqlConnectionManager.executeQueryRS(query);
        if (rs != null) {
            try {
                try {
                    while (rs.next()) {
                        FileStatus status = this.getDataFromResultSet(rs);
                        if (status == null) continue;
                        resultData.add(status);
                    }
                }
                catch (SQLException e) {
                    Logger.exception((Throwable)e);
                    SqlConnectionManager.releaseResultSet(rs);
                }
            }
            finally {
                SqlConnectionManager.releaseResultSet(rs);
            }
        }
        return resultData;
    }

    public FileStatus getDataFromResultSet(ResultSet rs) {
        FileStatus status = null;
        try {
            status = new FileStatus(rs.getInt(COLUMN.FILE_ID.index), rs.getInt(COLUMN.API_TYPE.index), rs.getLong(COLUMN.EVENT_TIME.index));
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
            return null;
        }
        return status;
    }

    public void insert(FileStatus insertData) {
        ArrayList<List<Object>> insertDataList = new ArrayList<List<Object>>();
        insertDataList.add(insertData.getDBData());
        this.insertData(insertDataList);
    }

    public List<FileStatus> select() {
        String query = String.format(SELECT_QUERY, new Object[0]);
        ArrayList<FileStatus> statusList = new ArrayList();
        statusList = this.executeQueryRS(query);
        return statusList;
    }

    public static String selectAll() {
        StringBuffer selectAllColumn = new StringBuffer();
        selectAllColumn.append(COLUMN.FILE_ID.name);
        selectAllColumn.append(",");
        selectAllColumn.append(COLUMN.API_TYPE.name);
        selectAllColumn.append(",");
        selectAllColumn.append(COLUMN.EVENT_TIME.name);
        return selectAllColumn.toString();
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setInt(1, (Integer)rowData.get(0));
                prep.setInt(2, (Integer)rowData.get(1));
                prep.setLong(3, (Long)rowData.get(2));
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }

    public static enum COLUMN {
        FILE_ID(1, "FILE_ID"),
        API_TYPE(2, "API_TYPE"),
        EVENT_TIME(3, "EVENT_TIME");

        private final int index;
        private final String name;

        private COLUMN(int index, String name) {
            this.index = index;
            this.name = name;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }
    }
}

