/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory;

import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.nl.MemoryPageLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.ui.memory.table.MemoryDetailsTable;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class MemoryDetailsTableView
extends DAViewComposite {
    public static final String ID = MemoryDetailsTableView.class.getName();
    public static final int ITEM_TABLE_IDEX = 0;
    public static final int CURRENT_TABLE_INDEX = 1;
    public static final int START_TABLE_INDEX = 2;
    public static final int END_TABLE_INDEX = 3;
    public static final int DELTA_TABLE_INDEX = 4;
    public static final int MIN_TABLE_INDEX = 5;
    public static final int MAX_TABLE_INDEX = 6;
    MemoryDetailsTable tableComp = null;

    public MemoryDetailsTableView(Composite parent, int style) {
        super(parent, style, false);
        this.setLayout((Layout)new FillLayout());
        this.setTitle(MemoryPageLabels.MEMORY_DETAILS_VIEW_TITLE);
        Composite contents = this.getContentArea();
        contents.setBackground(ColorResources.WINDOW_BG_COLOR);
        contents.setLayout((Layout)new FillLayout());
        this.tableComp = new MemoryDetailsTable(contents, 0, 68354);
    }

    public void updateView() {
        if (!AnalyzerManager.isVisibleView(this.getID())) {
            return;
        }
        if (this.tableComp == null) {
            return;
        }
        this.tableComp.updateTable();
    }

    public void updateView(DAViewData vdata) {
        if (!(vdata instanceof DASelectionData)) {
            return;
        }
        DASelectionData selData = (DASelectionData)vdata;
        if (selData.getStartTime() == selData.getEndTime()) {
            this.tableComp.setSelectionRange(0L, 0L, selData.getStartTime());
        } else {
            this.tableComp.setSelectionRange(selData.getStartTime(), selData.getEndTime(), -1L);
        }
        if (!AnalyzerManager.isVisibleView(this.getID())) {
            return;
        }
        this.tableComp.updateTable();
    }

    public void clear() {
        this.tableComp.clear();
    }

    public Control getControl() {
        return this.tableComp;
    }
}

