/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.opengl;

import org.tizen.dynamicanalyzer.constant.CommonConstants;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;

public class GLExtractUniformDataMaker {
    static final int PRINT_UNIFORM_VALUE_LENGTH = 10;

    boolean isUniformAPI(String apiName) {
        return apiName.contains("glUniform");
    }

    String getUniformData(String apiName, String parameter) {
        if (apiName.contains("glUniformMatrix")) {
            return this.getUniformDataFromPointer(apiName, parameter);
        }
        if (apiName.contains("glUniform1i") || apiName.contains("glUniform2i") || apiName.contains("glUniform3i") || apiName.contains("glUniform4i") || apiName.contains("glUniform1f") || apiName.contains("glUniform2f") || apiName.contains("glUniform3f") || apiName.contains("glUniform4f")) {
            return this.getUniformParameterValue(parameter);
        }
        if (apiName.contains("glUniform1iv") || apiName.contains("glUniform2iv") || apiName.contains("glUniform3iv") || apiName.contains("glUniform4iv") || apiName.contains("glUniform1fv") || apiName.contains("glUniform2fv") || apiName.contains("glUniform3fv") || apiName.contains("glUniform4fv")) {
            return this.getUniformDataFromPointer(apiName, parameter);
        }
        Logger.error((Object)("undefine uniform api : " + apiName));
        return null;
    }

    private String getUniformParameterValue(String parameter) {
        String[] parameterArray = this.getParameterArray(parameter);
        StringBuffer returnUniform = new StringBuffer();
        if (parameterArray == null) {
            return parameter;
        }
        int i = 1;
        while (i < parameterArray.length) {
            returnUniform.append(parameterArray[i]);
            if (i != parameterArray.length - 1) {
                returnUniform.append(",").append(" ");
            }
            ++i;
        }
        return returnUniform.toString();
    }

    private String getUniformDataFromPointer(String apiName, String parameter) {
        String[] uniformArray = this.getParameterArray(this.getUniformParameter(parameter));
        if (uniformArray == null) {
            Logger.error((Object)("parameter size is wrong : " + apiName + " parameter : " + parameter));
            return parameter;
        }
        return this.getAlignmentTableFormat(apiName, uniformArray);
    }

    private String getAlignmentTableFormat(String apiName, String[] uniformArray) {
        int uniformColumnSize = this.getUnifomColumnSize(apiName);
        StringBuffer returnUniformValue = new StringBuffer("\t");
        int i = 0;
        int columnIndex = 1;
        while (i < uniformArray.length) {
            if (AnalyzerUtil.isInteger(uniformArray[i])) {
                returnUniformValue.append(String.format("%010d", Integer.parseInt(uniformArray[i])));
            } else {
                returnUniformValue.append(this.getFloatValueToDefineLength(uniformArray[i]));
            }
            if (i != uniformArray.length - 1) {
                returnUniformValue.append(",").append(" ");
                if (columnIndex % uniformColumnSize == 0) {
                    returnUniformValue.append(CommonConstants.NEW_LINE).append("\t");
                }
            }
            ++i;
            ++columnIndex;
        }
        return returnUniformValue.toString();
    }

    private String getFloatValueToDefineLength(String value) {
        if (!value.contains(".")) {
            return value;
        }
        String floatValue = String.format("%.7f", Double.parseDouble(value));
        String[] floatValueSplit = floatValue.split("\\.");
        String aboveValue = floatValueSplit[0];
        StringBuffer returnValue = new StringBuffer();
        if (!aboveValue.contains("-")) {
            returnValue.append(" ");
        }
        returnValue.append(aboveValue).append(".");
        returnValue.append(floatValueSplit[1]);
        if (returnValue.toString().length() > 10) {
            returnValue.replace(10, returnValue.toString().length(), "");
        }
        return returnValue.toString();
    }

    private String[] getParameterArray(String uniformValue) {
        if (!uniformValue.contains(",")) {
            return null;
        }
        return uniformValue.split(",");
    }

    private String getUniformParameter(String parameter) {
        if (!parameter.contains("[")) {
            return parameter;
        }
        String[] parameterSplit = parameter.split("\\[");
        String returnUniformValue = parameterSplit[parameterSplit.length - 1];
        return returnUniformValue.replace("]", "");
    }

    private int getUnifomColumnSize(String apiName) {
        if (apiName.contains("1")) {
            return 1;
        }
        if (apiName.contains("2")) {
            return 2;
        }
        if (apiName.contains("3")) {
            return 3;
        }
        if (apiName.contains("4")) {
            return 4;
        }
        Logger.error((Object)("undefine uniform api : " + apiName));
        return 1;
    }
}

