/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.opengl.data;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.tizen.dynamicanalyzer.ui.opengl.data.GLDataManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLContextDefaultValueHashMap;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLContextNameEnum;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLStateProgramType;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLStateShaderType;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLStateTextureType;

public class GLContextDataManager {
    private static final int CONTEXT_VALUE_SIZE = GLContextNameEnum.values().length;
    public long contextID = -1L;
    public List<Long> sharingContextIdList = null;
    public List<GLStateProgramType> programList;
    public List<GLStateShaderType> shaderList;
    public List<GLStateTextureType> textureList;
    private List<Object> defaultValueList = null;
    private List<Object> preValueList = null;
    private List<Object> currentValueList = null;
    static int maxVertexAttribs = 5;
    static int maxTextureUnits = 5;
    private boolean isInitState = false;
    public List<Integer> gvaV0ValueList;
    public List<Integer> gvaV1ValueList;
    public List<Integer> gvaV2ValueList;
    public List<Integer> gvaV3ValueList;
    public List<Boolean> gvaEnabledValueList;
    public List<Integer> gvaSizeValueList;
    public List<Integer> gvaTypeValueList;
    public List<Integer> gvaNormalValueList;
    public List<Integer> gvaStrideValueList;
    public List<Long> gvaPointerValueList;
    public int vboArrayBinding;
    public int vboArrayID;
    public int vboArraySize;
    public long vboArrayData;
    public int vboArrayUsage;
    public int vboElementBinding;
    public int vboElementID;
    public int vboElementSize;
    public long vboElementData;
    public int vboElementUsage;

    public GLContextDataManager(long contextID) {
        this.contextID = contextID;
        this.gvaEnabledValueList = new ArrayList<Boolean>();
        this.gvaV0ValueList = new ArrayList<Integer>();
        this.gvaV1ValueList = new ArrayList<Integer>();
        this.gvaV2ValueList = new ArrayList<Integer>();
        this.gvaV3ValueList = new ArrayList<Integer>();
        this.gvaSizeValueList = new ArrayList<Integer>();
        this.gvaTypeValueList = new ArrayList<Integer>();
        this.gvaNormalValueList = new ArrayList<Integer>();
        this.gvaStrideValueList = new ArrayList<Integer>();
        this.gvaPointerValueList = new ArrayList<Long>();
        this.programList = new ArrayList<GLStateProgramType>();
        this.shaderList = new ArrayList<GLStateShaderType>();
        this.textureList = new ArrayList<GLStateTextureType>();
        this.sharingContextIdList = new ArrayList<Long>();
        this.vboArrayBinding = 0;
        this.vboArrayID = 0;
        this.vboArraySize = 0;
        this.vboArrayData = 0L;
        this.vboArrayUsage = 0;
        this.vboElementBinding = 0;
        this.vboElementID = 0;
        this.vboElementSize = 0;
        this.vboElementData = 0L;
        this.vboElementUsage = 0;
    }

    public void setVertexAttribs(int size) {
        maxVertexAttribs = size;
    }

    public void setTextureUnits(int size) {
        maxTextureUnits = size;
    }

    public void init() {
        int i = 0;
        while (i < maxVertexAttribs) {
            this.gvaEnabledValueList.add(null);
            this.gvaV0ValueList.add(null);
            this.gvaV1ValueList.add(null);
            this.gvaV2ValueList.add(null);
            this.gvaV3ValueList.add(null);
            this.gvaSizeValueList.add(null);
            this.gvaTypeValueList.add(null);
            this.gvaNormalValueList.add(null);
            this.gvaStrideValueList.add(null);
            this.gvaPointerValueList.add(null);
            this.isInitState = true;
            ++i;
        }
    }

    public long getContextID() {
        return this.contextID;
    }

    public void setContextID(long contextID) {
        this.contextID = contextID;
    }

    public List<Object> getDefaultValueList() {
        if (this.defaultValueList == null) {
            this.defaultValueList = this.initContextList();
        }
        return this.defaultValueList;
    }

    public void setDefaultValueList(List<Object> defaultValueList) {
        this.defaultValueList = defaultValueList;
    }

    public List<Object> getPreValueList() {
        if (this.preValueList == null) {
            this.preValueList = this.initContextList();
        }
        return this.preValueList;
    }

    public List<Object> getCurrentValueList() {
        if (this.currentValueList == null) {
            this.currentValueList = this.initContextList();
        }
        return this.currentValueList;
    }

    public void updateStateData(long contextID, long seq, int featureIndex, Object value, int frameRateIndex, int frameTimeIndex) {
        if (!this.isInitState) {
            this.init();
            this.initInsertForCompareValue(seq, featureIndex, frameRateIndex, frameTimeIndex);
        }
        if (this.isChangeStateValue(featureIndex, value)) {
            this.updateContextHistoryValue(seq, featureIndex, frameRateIndex, frameTimeIndex);
            GLDataManager.getInstance().getContextDBTableManage().insertContextData(this.getCurrentValueList());
        }
    }

    private void initInsertForCompareValue(long seq, int featureIndex, int frameRateIndex, int frameTimeIndex) {
        this.updateContextHistoryValue(seq, featureIndex, frameRateIndex, frameTimeIndex);
        GLDataManager.getInstance().getContextDBTableManage().insertContextData(this.getCurrentValueList());
    }

    private boolean isChangeStateValue(int featureIndex, Object newValue) {
        Object preValue = this.getPreValueList().get(featureIndex);
        boolean isChange = false;
        if (this.isChangeIntegerValue(featureIndex, preValue, newValue)) {
            isChange = true;
            this.getPreValueList().set(featureIndex, (Integer)newValue);
            this.getCurrentValueList().set(featureIndex, (Integer)newValue);
        } else if (this.isChangeLongValue(featureIndex, preValue, newValue)) {
            isChange = true;
            this.getPreValueList().set(featureIndex, (Long)newValue);
            this.getCurrentValueList().set(featureIndex, (Long)newValue);
        } else if (this.isChangeBooleanValue(featureIndex, preValue, newValue)) {
            isChange = true;
            this.getPreValueList().set(featureIndex, (Boolean)newValue);
            this.getCurrentValueList().set(featureIndex, (Boolean)newValue);
        } else if (this.isChangeStringValue(featureIndex, preValue, newValue)) {
            isChange = true;
            this.getPreValueList().set(featureIndex, (String)newValue);
            this.getCurrentValueList().set(featureIndex, (String)newValue);
        } else if (this.isChangeBooleanArrayValue(featureIndex, preValue, newValue)) {
            isChange = true;
            ArrayList<Boolean> insertList = new ArrayList<Boolean>();
            List currentStateList = (List)newValue;
            int i = 0;
            while (i < currentStateList.size()) {
                insertList.add((Boolean)currentStateList.get(i));
                ++i;
            }
            this.getPreValueList().set(featureIndex, insertList);
            this.getCurrentValueList().set(featureIndex, insertList);
        } else if (this.isChangeIntegerArrayValue(featureIndex, preValue, newValue)) {
            isChange = true;
            ArrayList<Integer> insertList = new ArrayList<Integer>();
            List currentStateList = (List)newValue;
            int i = 0;
            while (i < currentStateList.size()) {
                insertList.add((Integer)currentStateList.get(i));
                ++i;
            }
            this.getPreValueList().set(featureIndex, insertList);
            this.getCurrentValueList().set(featureIndex, insertList);
        } else if (this.isChangeLongArrayValue(featureIndex, preValue, newValue)) {
            isChange = true;
            ArrayList<Long> insertList = new ArrayList<Long>();
            List currentStateList = (List)newValue;
            int i = 0;
            while (i < currentStateList.size()) {
                insertList.add((Long)currentStateList.get(i));
                ++i;
            }
            this.getPreValueList().set(featureIndex, insertList);
            this.getCurrentValueList().set(featureIndex, insertList);
        }
        return isChange;
    }

    private void updateContextHistoryValue(long seq, int featureIndex, int frameRateIndex, int frameTimeIndex) {
        this.getPreValueList().set(GLContextNameEnum.SEQ.ordinal(), seq);
        this.getPreValueList().set(GLContextNameEnum.CONTEXT_ID.ordinal(), this.contextID);
        this.getCurrentValueList().set(GLContextNameEnum.SEQ.ordinal(), seq);
        this.getCurrentValueList().set(GLContextNameEnum.CONTEXT_ID.ordinal(), this.contextID);
        GLDataManager.getInstance().getStateHistoryDBTableManage().insertData(this.contextID, featureIndex, seq, frameRateIndex, frameTimeIndex);
    }

    private boolean isChangeIntegerValue(int featureIndex, Object preValue, Object newValue) {
        int newInt;
        if (!GLDataManager.getInstance().getContextDBTableManage().isIntegerType(featureIndex)) {
            return false;
        }
        int preInt = (Integer)preValue;
        return preInt != (newInt = ((Integer)newValue).intValue());
    }

    private boolean isChangeLongValue(int featureIndex, Object preValue, Object newValue) {
        long newLong;
        if (!GLDataManager.getInstance().getContextDBTableManage().isLongType(featureIndex)) {
            return false;
        }
        long preLong = (Long)preValue;
        return preLong != (newLong = ((Long)newValue).longValue());
    }

    private boolean isChangeBooleanValue(int featureIndex, Object preValue, Object newValue) {
        boolean newBoolean;
        if (!GLDataManager.getInstance().getContextDBTableManage().isBooleans(featureIndex)) {
            return false;
        }
        boolean preBoolean = (Boolean)preValue;
        return preBoolean != (newBoolean = ((Boolean)newValue).booleanValue());
    }

    private boolean isChangeStringValue(int featureIndex, Object preValue, Object newValue) {
        if (!GLDataManager.getInstance().getContextDBTableManage().isStringType(featureIndex)) {
            return false;
        }
        String preData = (String)preValue;
        String newData = (String)newValue;
        return !preData.equals(newData);
    }

    private boolean isChangeBooleanArrayValue(int featureIndex, Object preValue, Object newValue) {
        if (!GLDataManager.getInstance().getContextDBTableManage().isBooleanArray(featureIndex)) {
            return false;
        }
        List preStateList = (List)this.getPreValueList().get(featureIndex);
        List currentStateList = (List)newValue;
        int i = 0;
        while (i < currentStateList.size()) {
            Boolean newStatus = (Boolean)currentStateList.get(i);
            if (preStateList == null) {
                return true;
            }
            Boolean preStatus = (Boolean)preStateList.get(i);
            if (newStatus != null || preStatus != null) {
                if (newStatus == null && preStatus != null) {
                    return true;
                }
                if (newStatus != null && preStatus == null) {
                    return true;
                }
                if (preStatus.compareTo(newStatus) != 0) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private boolean isChangeIntegerArrayValue(int featureIndex, Object preValue, Object newValue) {
        if (!GLDataManager.getInstance().getContextDBTableManage().isIntegerArray(featureIndex)) {
            return false;
        }
        List preStateList = (List)this.getPreValueList().get(featureIndex);
        List currentStateList = (List)newValue;
        int i = 0;
        while (i < currentStateList.size()) {
            Integer newStatus = (Integer)currentStateList.get(i);
            if (preStateList == null) {
                return true;
            }
            Integer preStatus = (Integer)preStateList.get(i);
            if (newStatus != null || preStatus != null) {
                if (newStatus == null && preStatus != null) {
                    return true;
                }
                if (newStatus != null && preStatus == null) {
                    return true;
                }
                if (preStatus.compareTo(newStatus) != 0) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private boolean isChangeLongArrayValue(int featureIndex, Object preValue, Object newValue) {
        if (!GLDataManager.getInstance().getContextDBTableManage().isLongArray(featureIndex)) {
            return false;
        }
        List preStateList = (List)this.getPreValueList().get(featureIndex);
        List currentStateList = (List)newValue;
        int i = 0;
        while (i < currentStateList.size()) {
            Long newStatus = (Long)currentStateList.get(i);
            if (preStateList == null) {
                return true;
            }
            Long preStatus = (Long)preStateList.get(i);
            if (newStatus != null || preStatus != null) {
                if (newStatus == null && preStatus != null) {
                    return true;
                }
                if (newStatus != null && preStatus == null) {
                    return true;
                }
                if (preStatus.compareTo(newStatus) != 0) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private List<Object> initContextList() {
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (i < CONTEXT_VALUE_SIZE) {
            String stateName = GLContextNameEnum.values()[i].getcolumnName();
            Object defaultValue = GLContextDefaultValueHashMap.getDefaultValue(stateName);
            list.add(defaultValue);
            ++i;
        }
        return list;
    }

    public void addSharingContextID(LinkedHashMap<Long, GLContextDataManager> contextMap, long sharingContextId) {
        this.updateSharingListOfCurrentContext(contextMap, sharingContextId);
        this.updateSharingListOfSharingContext(contextMap, sharingContextId);
    }

    private void updateSharingListOfCurrentContext(LinkedHashMap<Long, GLContextDataManager> contextMap, long sharingContextId) {
        this.sharingContextIdList.add(sharingContextId);
        GLContextDataManager sharingContextValueType = contextMap.get(sharingContextId);
        if (sharingContextValueType == null) {
            return;
        }
        int i = 0;
        while (i < sharingContextValueType.sharingContextIdList.size()) {
            long savedSharingContextId = sharingContextValueType.sharingContextIdList.get(i);
            if (this.isFinishUpdateCurrentContextDataManger(savedSharingContextId, sharingContextId) || this.isFinishUpdateSharingContextDataManger(savedSharingContextId, sharingContextId)) {
                return;
            }
            this.sharingContextIdList.add(savedSharingContextId);
            ++i;
        }
        sharingContextValueType.addSharingContextID(contextMap, this.contextID);
    }

    private void updateSharingListOfSharingContext(LinkedHashMap<Long, GLContextDataManager> contextMap, long sharingContextId) {
        GLContextDataManager sharingContextValueType = contextMap.get(sharingContextId);
        if (sharingContextValueType == null) {
            return;
        }
        int i = 0;
        while (i < sharingContextValueType.sharingContextIdList.size()) {
            long savedSharingContextId = sharingContextValueType.sharingContextIdList.get(i);
            if (this.isFinishUpdateCurrentContextDataManger(savedSharingContextId, sharingContextId)) {
                return;
            }
            GLContextDataManager savedSharingContextValueType = contextMap.get(savedSharingContextId);
            savedSharingContextValueType.addSharingContextID(contextMap, this.contextID);
            ++i;
        }
    }

    private boolean isFinishUpdateCurrentContextDataManger(long savedSharingContextId, long sharingContextId) {
        return savedSharingContextId == this.contextID || savedSharingContextId == sharingContextId;
    }

    private boolean isFinishUpdateSharingContextDataManger(long savedSharingContextId, long sharingContextId) {
        int j = 0;
        while (j < this.sharingContextIdList.size()) {
            long ContextId = this.sharingContextIdList.get(j);
            if (savedSharingContextId == ContextId) {
                return true;
            }
            ++j;
        }
        return false;
    }
}

