/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.summary.profiling;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.swap.model.data.WebProfileData;
import org.tizen.dynamicanalyzer.ui.summary.profiling.FunctionUsageProfiler;

public class WebProfilingData {
    private static int internalSeq = 0;
    private int profilingDataID = -1;
    private long startTime = -1L;
    private long lastExeTime = 0L;
    private long childExeTime = 0L;
    private WebProfilingData parent = null;
    private WebProfilingData parentWebProfilingData = null;
    private List<Integer> childrenWebProfilingDataID = new ArrayList<Integer>();
    private String functionName = null;
    private int functionLineNumber = 0;
    private String functionURL = null;
    private int callCount = 0;
    private long inElapsedTime = 0L;
    private long exElapsedTime = 0L;

    public WebProfilingData(int profilingDataID, int functionLineNumber, String functionName, String functionURL, int callCount, long inElapsedTime, long exElapsedTime, List<Integer> childrenWebProfilingDataID) {
        this.profilingDataID = profilingDataID;
        this.functionLineNumber = functionLineNumber;
        this.functionName = functionName;
        this.functionURL = functionURL;
        this.callCount = callCount;
        this.inElapsedTime = inElapsedTime;
        this.exElapsedTime = exElapsedTime;
        if (childrenWebProfilingDataID != null) {
            this.childrenWebProfilingDataID = childrenWebProfilingDataID;
        }
    }

    public WebProfilingData(String functionName) {
        this.functionName = functionName;
        if (functionName.equals(FunctionUsageProfiler.APPLICATION)) {
            this.functionURL = "";
        }
        this.profilingDataID = internalSeq++;
    }

    public WebProfilingData(WebProfileData log) {
        this(log.getFunctionName());
        this.functionLineNumber = log.getFunctionLineNumber();
        this.functionURL = log.getFunctionURL();
        this.startTime = log.getTime();
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public int getFunctionLineNumber() {
        return this.functionLineNumber;
    }

    public void setFunctionLineNumber(int functionLineNumber) {
        this.functionLineNumber = functionLineNumber;
    }

    public String getFunctionURL() {
        return this.functionURL;
    }

    public void setFunctionURL(String functionURL) {
        this.functionURL = functionURL;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void initStartTime() {
        this.startTime = -1L;
    }

    public int getProfilingDataID() {
        return this.profilingDataID;
    }

    public void setProfilingDataID(int profilingDataID) {
        this.profilingDataID = profilingDataID;
    }

    public void addCallCount() {
        ++this.callCount;
    }

    public int getCallCount() {
        return this.callCount;
    }

    public void addElapsedTime(long time) {
        this.lastExeTime = time;
        this.inElapsedTime += time;
    }

    public long getLastElapsedTime() {
        return this.lastExeTime;
    }

    public void addExclusiveElapsedTime(long time) {
        this.exElapsedTime += time;
    }

    public long getExclusiveExeTime() {
        return this.lastExeTime - this.childExeTime;
    }

    public void addChildExeTime(long time) {
        this.childExeTime += time;
    }

    public void initRelationData() {
        this.parent = null;
        this.childExeTime = 0L;
        this.lastExeTime = 0L;
    }

    public long getInElapsedTime() {
        return this.inElapsedTime;
    }

    public long getExElapsedTime() {
        return this.exElapsedTime;
    }

    public WebProfilingData getParent() {
        return this.parent;
    }

    public void setParent(WebProfilingData parent) {
        this.parent = parent;
    }

    public WebProfilingData getParentWebProfilingData() {
        return this.parentWebProfilingData;
    }

    public void setParentWebProfilingData(WebProfilingData parentWebProfilingData) {
        this.parentWebProfilingData = parentWebProfilingData;
    }

    public List<Integer> getChildrenWebProfilingDataID() {
        return this.childrenWebProfilingDataID;
    }

    public void addChildrenWebProfilingDataID(int profilingDataID) {
        this.childrenWebProfilingDataID.add(profilingDataID);
    }

    public String generateFunctionKey() {
        return String.valueOf(this.functionURL) + this.functionLineNumber + this.functionName;
    }

    public static void clear() {
        internalSeq = 0;
    }
}

