/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.summary.warning;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.listeners.SummaryMouseDoubleClickListener;
import org.tizen.dynamicanalyzer.model.FilterProperty;
import org.tizen.dynamicanalyzer.model.TableInput;
import org.tizen.dynamicanalyzer.swap.model.data.LogDataFactory;
import org.tizen.dynamicanalyzer.swap.model.data.ProbeCommonData;
import org.tizen.dynamicanalyzer.ui.summary.SummaryDataManager;
import org.tizen.dynamicanalyzer.ui.summary.SummaryPage;
import org.tizen.dynamicanalyzer.ui.summary.warning.WarningCase;
import org.tizen.dynamicanalyzer.ui.summary.warning.WarningDataDBTable;
import org.tizen.dynamicanalyzer.ui.summary.warning.WarningDataMaker;
import org.tizen.dynamicanalyzer.ui.summary.warning.WarningDataView;
import org.tizen.dynamicanalyzer.ui.timeline.TimelinePage;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;

public class WarningTable
extends DATableComposite {
    private final WarningDataMaker warningDataMaker = SummaryDataManager.getInstance().getWarningDataMaker();

    public WarningTable(Composite parent, int compStyle, int tableStyle) {
        super(parent, compStyle, tableStyle);
        this.setContextMenu(1);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GridItem[] items = WarningTable.this.table.getSelection();
                DATableDataFormat dataFormat = (DATableDataFormat)items[0].getData();
                long time = dataFormat.getLogData().getTime();
                String id = SummaryPage.warningListViewID;
                DASelectionData selData = new DASelectionData(id, time, 0L, items, (Control)WarningTable.this.table);
                long seq = ((DATableDataFormat)((GridItem[])selData.getData())[0].getData()).getLogData().getSeq();
                String warningMessage = SummaryDataManager.getInstance().getWarningDataMaker().getFullWarningMessageByLogSeq(seq);
                ((WarningDataView)((TimelinePage)AnalyzerUtil.getTabPage(TimelinePage.pageID)).getView(WarningDataView.class.getName())).updateWarningDetailMessage(warningMessage);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.table.addMouseListener((MouseListener)new SummaryMouseDoubleClickListener(SummaryPage.warningListViewID));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected List<TableInput> makeTableInput() {
        ArrayList<List<Object>> warningData = null;
        warningData = this.warningDataMaker.getWarningDataList();
        if (warningData == null) {
            return null;
        }
        List<FilterProperty> filterList = this.getFilterPropertyList();
        ArrayList<TableInput> input = new ArrayList<TableInput>();
        int size = warningData.size();
        int i = 0;
        while (i < size) {
            block10: {
                List idata = (List)warningData.get(i);
                int selectedPid = Toolbar.INSTANCE.getSelectedPid();
                int pid = (Integer)idata.get(WarningDataDBTable.COLUMN.PID.index);
                if ((selectedPid == 0 || selectedPid == pid) && this.isVaildData(idata)) {
                    int msgID = (Integer)idata.get(WarningDataDBTable.COLUMN.MESSAGE_ID.index);
                    String category = LogDataFactory.getLogFormatName(msgID);
                    String pidString = Integer.toString(pid);
                    int warningCase = (Integer)idata.get(WarningDataDBTable.COLUMN.WARNING_CASE.index);
                    String message = WarningCase.getShortWarningMessage(warningCase);
                    int index = 0;
                    while (index < filterList.size()) {
                        switch (filterList.get(index).getColumnIndex()) {
                            case 1: {
                                if (category.toLowerCase().contains(filterList.get(index).getKeyWord().toLowerCase())) break;
                                break block10;
                            }
                            case 2: {
                                if (pidString.contains(filterList.get(index).getKeyWord())) break;
                                break block10;
                            }
                            case 3: {
                                if (!message.toLowerCase().contains(filterList.get(index).getKeyWord().toLowerCase())) break block10;
                            }
                        }
                        ++index;
                    }
                    ArrayList<String> text = new ArrayList<String>();
                    ArrayList<String> data = new ArrayList<String>();
                    int rid = (Integer)idata.get(WarningDataDBTable.COLUMN.RID.index);
                    text.add(Integer.toString(rid));
                    data.add(Integer.toString(rid));
                    text.add(category);
                    data.add(category);
                    text.add(pidString);
                    data.add(pidString);
                    text.add(message);
                    data.add(message);
                    long seq = (Long)idata.get(WarningDataDBTable.COLUMN.SEQUENCE_NUMBER.index);
                    DATableDataFormat tableData = new DATableDataFormat(seq);
                    ProbeCommonData probeData = new ProbeCommonData();
                    probeData.setSeq(seq);
                    probeData.setMsgID(msgID);
                    probeData.setPid(pid);
                    probeData.setTid((Integer)idata.get(WarningDataDBTable.COLUMN.TID.index));
                    probeData.setTime((Long)idata.get(WarningDataDBTable.COLUMN.START_TIME.index));
                    probeData.setReserved1(warningCase);
                    probeData.setCallerAddress((Long)idata.get(WarningDataDBTable.COLUMN.CALLER_PC_ADDRESS.index));
                    probeData.setLibName((String)idata.get(WarningDataDBTable.COLUMN.CALLER_LIBRARY_NAME.index));
                    tableData.getData().addAll(data);
                    tableData.setLogData(probeData);
                    tableData.setType(8);
                    TableInput tableInput = new TableInput();
                    tableInput.setText(text);
                    tableInput.setData(tableData);
                    input.add(tableInput);
                }
            }
            ++i;
        }
        return input;
    }

    private boolean isVaildData(List<Object> idata) {
        Long markerStartTime = 0L;
        Long markerEndTime = Toolbar.INSTANCE.getTime();
        Long startTime = (Long)idata.get(WarningDataDBTable.COLUMN.START_TIME.index);
        Long endTime = (Long)idata.get(WarningDataDBTable.COLUMN.END_TIME.index);
        if (startTime < markerStartTime || markerEndTime < startTime) {
            return false;
        }
        return endTime == -1L || markerStartTime > endTime || endTime > markerEndTime;
    }
}

