/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.thread.type;

import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.utils.Formatter;

public abstract class ThreadPageDataEvent
implements Cloneable {
    private LogData contents;
    private long time = -1L;
    private int tid = -1;
    private int apiType = -1;
    private String tooltip = null;
    private long errorNum = -1L;

    public ThreadPageDataEvent(long time, int tid, int apiType, String tooltip, long errorNum, LogData contents) {
        this.setTime(time);
        this.setTid(tid);
        this.setApiType(apiType);
        this.setTooltipContent(tooltip);
        this.setErrorNum(errorNum);
        this.setContents(contents);
    }

    public ThreadPageDataEvent clone() throws CloneNotSupportedException {
        ThreadPageDataEvent dataEvent = (ThreadPageDataEvent)super.clone();
        dataEvent.setContents(this.contents);
        dataEvent.setTime(this.time);
        dataEvent.setTid(this.tid);
        dataEvent.setApiType(this.apiType);
        dataEvent.setTooltipContent(this.tooltip);
        dataEvent.setErrorNum(this.errorNum);
        return dataEvent;
    }

    public LogData getContents() {
        return this.contents;
    }

    public void setContents(LogData contents) {
        this.contents = contents;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public double getDoubleTime() {
        double dTime = Formatter.longTimeToDoubleTime(this.time);
        return dTime;
    }

    public int getTid() {
        return this.tid;
    }

    public void setTid(int tid) {
        this.tid = tid;
    }

    public int getApiType() {
        return this.apiType;
    }

    public void setApiType(int apiType) {
        this.apiType = apiType;
    }

    public String getTooltipContent() {
        return this.tooltip;
    }

    public void setTooltipContent(String tooltip) {
        this.tooltip = tooltip;
    }

    public long getErrorNum() {
        return this.errorNum;
    }

    public void setErrorNum(long errorNum) {
        this.errorNum = errorNum;
    }
}

