/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.timeline.logparser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.graphics.Color;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.nl.TimelineChartLabels;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.swap.logparser.LogPackage;
import org.tizen.dynamicanalyzer.swap.logparser.Logs;
import org.tizen.dynamicanalyzer.swap.model.data.LifeCycleLogData;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.lifecycle.LifecycleBar;
import org.tizen.dynamicanalyzer.widgets.lifecycle.LifecycleData;
import org.tizen.dynamicanalyzer.widgets.timeline.DATimeline;

public class LifecycleLogParser {
    private static LifecycleLogParser instance = null;
    private static final String API_NAME_INITIALIZING_OSP = "_AppInfo::SetAppState(AppState appState)";
    private static final String API_NAME_RUNNING_OSP = "_UiAppImpl::OnForeground(void)";
    private static final String API_NAME_PAUSING_OSP = "_UiAppImpl::OnBackground(void)";
    private static final String API_NAME_TERMINATING_OSP = "_AppImpl::OnTerminate(void* user_data)";
    private static final String API_NAME_INITIALIZING_EFL = "_dalc_app_create";
    private static final String API_NAME_SERVICE_EFL = "_dalc_app_service";
    private static final String API_NAME_RESUME_EFL = "_dalc_app_resume";
    private static final String API_NAME_PAUSING_EFL = "_dalc_app_pause";
    private static final String API_NAME_TERMINATING_EFL = "_dalc_app_terminate";
    private int API_ID_INITIALIZING_OSP = 0;
    private int API_ID_RUNNING_OSP = 0;
    private int API_ID_PAUSING_OSP = 0;
    private int API_ID_TERMINATING_OSP = 0;
    private int API_ID_INITIALIZING_EFL = 0;
    private int API_ID_SERVICE_EFL = 0;
    private int API_ID_RESUME_EFL = 0;
    private int API_ID_PAUSING_EFL = 0;
    private int API_ID_TERMINATING_EFL = 0;
    private Set<LifecycleBar> lifecycleBarList = new HashSet<LifecycleBar>();
    private List<DATimeline> timelineList = new ArrayList<DATimeline>();

    public static LifecycleLogParser getInstance() {
        if (instance == null) {
            instance = new LifecycleLogParser();
        }
        return instance;
    }

    private LifecycleLogParser() {
    }

    public void initialize(Project project) {
        this.API_ID_INITIALIZING_OSP = project.getFunctionID(API_NAME_INITIALIZING_OSP);
        this.API_ID_RUNNING_OSP = project.getFunctionID(API_NAME_RUNNING_OSP);
        this.API_ID_PAUSING_OSP = project.getFunctionID(API_NAME_PAUSING_OSP);
        this.API_ID_TERMINATING_OSP = project.getFunctionID(API_NAME_TERMINATING_OSP);
        this.API_ID_INITIALIZING_EFL = project.getFunctionID(API_NAME_INITIALIZING_EFL);
        this.API_ID_SERVICE_EFL = project.getFunctionID(API_NAME_SERVICE_EFL);
        this.API_ID_RESUME_EFL = project.getFunctionID(API_NAME_RESUME_EFL);
        this.API_ID_PAUSING_EFL = project.getFunctionID(API_NAME_PAUSING_EFL);
        this.API_ID_TERMINATING_EFL = project.getFunctionID(API_NAME_TERMINATING_EFL);
    }

    public void parseLogPackage(LogPackage logPack) {
        Logs logs = logPack.getLogs(261);
        if (logs == null) {
            return;
        }
        List<LogData> logDataList = logs.getRawLogs();
        for (LogData logData : logDataList) {
            this.parseLog(logData.getTime(), ((LifeCycleLogData)logData).getApiId());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void parseLog(long lifeChangeTime, int lifeStatus) {
        String text;
        Color color;
        block16: {
            block17: {
                block18: {
                    if (Global.getProject() == null || !Global.isGUIMode()) {
                        return;
                    }
                    if (!Global.getProject().getApplicationInfo().getAppType().contains("capp")) break block17;
                    if (lifeStatus != this.API_ID_INITIALIZING_EFL) break block18;
                    color = ColorResources.LIFECYCLE_INITIALIZING;
                    text = TimelineChartLabels.LIFECYCLE_INITIALIZING;
                    break block16;
                }
                if (lifeStatus == this.API_ID_SERVICE_EFL || lifeStatus == this.API_ID_RESUME_EFL) {
                    color = ColorResources.LIFECYCLE_RUNNING;
                    text = TimelineChartLabels.LIFECYCLE_RUNNING;
                    break block16;
                } else if (lifeStatus == this.API_ID_PAUSING_EFL) {
                    color = ColorResources.LIFECYCLE_PAUSING;
                    text = TimelineChartLabels.LIFECYCLE_PAUSING;
                    break block16;
                } else {
                    if (lifeStatus != this.API_ID_TERMINATING_EFL) {
                        Logger.error((String)"lifecycle log error (%d)", (Object[])new Object[]{lifeStatus});
                        return;
                    }
                    color = ColorResources.LIFECYCLE_TERMINATING;
                    text = TimelineChartLabels.LIFECYCLE_TERMINATING;
                }
                break block16;
            }
            if (!Global.getProject().getApplicationInfo().getAppType().contains("c++")) {
                Logger.error((Object)"It doesn't support lifecycle application type.");
                return;
            }
            if (lifeStatus == this.API_ID_INITIALIZING_OSP) {
                color = ColorResources.LIFECYCLE_INITIALIZING;
                text = TimelineChartLabels.LIFECYCLE_INITIALIZING;
            } else if (lifeStatus == this.API_ID_RUNNING_OSP) {
                color = ColorResources.LIFECYCLE_RUNNING;
                text = TimelineChartLabels.LIFECYCLE_RUNNING;
            } else if (lifeStatus == this.API_ID_PAUSING_OSP) {
                color = ColorResources.LIFECYCLE_PAUSING;
                text = TimelineChartLabels.LIFECYCLE_PAUSING;
            } else {
                if (lifeStatus != this.API_ID_TERMINATING_OSP) {
                    Logger.error((String)"lifecycle log error (%d)", (Object[])new Object[]{lifeStatus});
                    return;
                }
                color = ColorResources.LIFECYCLE_TERMINATING;
                text = TimelineChartLabels.LIFECYCLE_TERMINATING;
            }
        }
        double startTime = Double.parseDouble(Long.toString(lifeChangeTime)) / 1000000.0;
        LifecycleData lifecycleData = new LifecycleData(startTime, color, text);
        for (LifecycleBar lifecycleBar : this.lifecycleBarList) {
            lifecycleBar.addLifecycleData(lifecycleData);
        }
        for (DATimeline timeline : this.timelineList) {
            timeline.addStickyTime(startTime);
        }
    }

    public void registerLifecycleBar(LifecycleBar lifecycleBar) {
        this.lifecycleBarList.add(lifecycleBar);
    }

    public void registerTimeline(DATimeline timeline) {
        this.timelineList.add(timeline);
    }
}

