/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar.setting;

import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.nl.ConfigureLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.setting.FlatFeature;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.setting.TargetData;
import org.tizen.dynamicanalyzer.ui.toolbar.setting.FlatFeatureDialog;
import org.tizen.dynamicanalyzer.ui.toolbar.setting.PreferencesDialog;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.toggle.DACustomToggleButton;
import org.tizen.dynamicanalyzer.widgets.da.view.DABaseComposite;

public class FlatFeatureDialogSelectedFeaturePage
extends DABaseComposite {
    private FlatFeatureDialog featureDialog = null;
    private Composite selectedComp = null;
    private ScrolledComposite selecetedScrolledComp = null;
    private Composite selectedInputComp = null;
    private Label selectedFeatureLabel = null;
    private Label selectedIcon = null;
    private Label selectedNameLabel = null;
    private Label noItemLabel = null;
    private DACustomToggleButton delToggle = null;
    private Cursor daCursor = null;
    private static int TITLE_FONT_SIZE = 16;
    private static int ICON_SIZE = 40;
    private static int ITEM_LEFT = 20;
    private static int BODY_TOP_MARGIN = 30;
    private static int ITEM_DIST = 23;
    private static int ICON_TITLE_DIST = 15;
    private static int ITEM_TITLE_TOP = (ICON_SIZE - TITLE_FONT_SIZE) / 2;
    private static int ITEM_TITLE_LEFT = ITEM_LEFT + ICON_SIZE + ICON_TITLE_DIST;
    private static int ITEM_TITLE_WIDTH = 145;
    private static int BUTTON_SIZE = 15;
    private static int BUTTON_TOP = (ICON_SIZE - BUTTON_SIZE) / 2;
    private static int BUTTON_RIGHT = -30;
    private static int BUTTON_SPACING = -10;
    private static int VSCROLL_MARGIN = -3;
    private int width = 0;
    private int height = 0;
    private int line = 0;
    private int titleHeight = 0;
    private int titleTop = 0;
    private int bodyHeight = 0;
    private int bodyTop = 0;
    private int noItemUpperMargin = 0;
    private int noItemTopMargin = 0;
    private Listener cursorListener = new Listener(){
        private Cursor arrowCursor;
        private Cursor handCursor;
        {
            this.arrowCursor = new Cursor((Device)FlatFeatureDialogSelectedFeaturePage.this.getShell().getDisplay(), 0);
            this.handCursor = new Cursor((Device)FlatFeatureDialogSelectedFeaturePage.this.getShell().getDisplay(), 21);
        }

        public void handleEvent(Event event) {
            if (event.type == 6 || event.type == 7) {
                DACustomButton toggleButton = (DACustomButton)event.widget;
                toggleButton.setFocus();
                if (event.type == 6) {
                    FlatFeatureDialogSelectedFeaturePage.this.daCursor = this.handCursor;
                } else if (event.type == 7) {
                    FlatFeatureDialogSelectedFeaturePage.this.daCursor = this.arrowCursor;
                } else {
                    return;
                }
                FlatFeatureDialogSelectedFeaturePage.this.getShell().setCursor(FlatFeatureDialogSelectedFeaturePage.this.daCursor);
            }
        }
    };
    private Listener deleteClickListener = event -> {
        DACustomToggleButton toggleButton = (DACustomToggleButton)event.widget;
        TargetData target = SettingDataManager.INSTANCE.getTarget(null);
        target.removeSelectedFlatFeature(toggleButton.getText());
        this.featureDialog.getFeatureListPage().featureToggleUnselect(toggleButton.getText());
        this.createSelectedFeatureComposite();
    };
    private Listener configClickListener = event -> {
        DACustomButton toggleButton = (DACustomButton)event.widget;
        FlatFeature selectedFeature = FlatFeature.getFlatFeature((String)toggleButton.getData());
        new PreferencesDialog(this.getShell()).open(selectedFeature);
    };

    public FlatFeatureDialogSelectedFeaturePage(Composite parent, FlatFeatureDialog parentObject, int style) {
        super(parent, style);
        this.setLayout((Layout)new FormLayout());
        this.selectedComp = parent;
        this.featureDialog = parentObject;
        this.width = this.featureDialog.SELECTED_WIDTH;
        ((Object)((Object)this.featureDialog)).getClass();
        this.height = 527;
        this.line = this.featureDialog.LINE;
        this.titleHeight = this.featureDialog.TITLE_HEIGHT;
        this.titleTop = (this.titleHeight - TITLE_FONT_SIZE) / 2;
        this.bodyTop = this.titleHeight + this.line + 1;
        this.bodyHeight = this.height - this.titleHeight - this.line;
        this.noItemUpperMargin = (this.bodyHeight - TITLE_FONT_SIZE) / 2;
        this.noItemTopMargin = 15;
        this.createSelectedFeatureComposite();
    }

    private void initSelectedFeatureCompositeWidget() {
        if (this.selecetedScrolledComp != null) {
            this.selecetedScrolledComp.dispose();
            this.selecetedScrolledComp = null;
        }
        if (this.selectedInputComp != null) {
            this.selectedInputComp.dispose();
            this.selectedInputComp = null;
        }
        if (this.selectedFeatureLabel != null) {
            this.selectedFeatureLabel.dispose();
            this.selectedFeatureLabel = null;
        }
        if (this.selectedIcon != null) {
            this.selectedIcon.dispose();
            this.selectedIcon = null;
        }
        if (this.selectedNameLabel != null) {
            this.selectedNameLabel.dispose();
            this.selectedNameLabel = null;
        }
        if (this.noItemLabel != null) {
            this.noItemLabel.dispose();
            this.noItemLabel = null;
        }
    }

    private DACustomToggleButton createToggleButton(Composite composit, Image image, Point imagePoint, String title, Point fontPoint, int width, int height, int topPosition, int leftPosition) {
        DACustomToggleButton toggle = new DACustomToggleButton(composit, 0);
        toggle.setColors(ColorResources.SETTING_BUTTON_NORMAL_COLOR, ColorResources.SETTING_BUTTON_NORMAL_COLOR, ColorResources.SETTING_BUTTON_NORMAL_COLOR, ColorResources.SETTING_BUTTON_NORMAL_COLOR, ColorResources.SETTING_BUTTON_NORMAL_COLOR, ColorResources.SETTING_BUTTON_NORMAL_COLOR, ColorResources.SETTING_BUTTON_NORMAL_COLOR, ColorResources.SETTING_BUTTON_NORMAL_COLOR);
        toggle.setButtonImages(image, image, image, image, image, image, image, image);
        toggle.setButtonImagePoint(imagePoint);
        toggle.setTitle(title);
        toggle.setFontPoint(fontPoint);
        toggle.setFontColors(ColorResources.SETTING_COLOR, ColorResources.SETTING_COLOR, ColorResources.SETTING_COLOR, ColorResources.SETTING_COLOR);
        toggle.setButtonFont(FontResources.SETTING_BUTTON_FONT);
        FormData data = new FormData();
        data.top = new FormAttachment(0, topPosition);
        data.left = new FormAttachment(0, leftPosition);
        data.width = width;
        data.height = height;
        toggle.setLayoutData((Object)data);
        return toggle;
    }

    public DACustomToggleButton getDelToggle() {
        return this.delToggle;
    }

    public void createSelectedFeatureComposite() {
        this.initSelectedFeatureCompositeWidget();
        this.selectedFeatureLabel = new Label(this.selectedComp, 0x40000000);
        FormData data = new FormData();
        data.top = new FormAttachment(0, this.titleTop);
        data.left = new FormAttachment(0, ITEM_LEFT);
        data.width = this.width - ITEM_LEFT;
        data.height = this.titleHeight - this.titleTop - TITLE_FONT_SIZE + 6;
        this.selectedFeatureLabel.setLayoutData((Object)data);
        this.selectedFeatureLabel.setText(ConfigureLabels.SETTING_DIALOG_SELECTED_TITLE);
        this.selectedFeatureLabel.setBackground(ColorResources.FEATURE_TITLE_BACKGROUND);
        this.selectedFeatureLabel.setForeground(ColorResources.DEFAULT_FONT_COLOR);
        this.selectedFeatureLabel.setFont(FontResources.SETTING_TITLE_FONT);
        this.selectedFeatureLabel.setAlignment(16384);
        this.selectedComp.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(ColorResources.FEATURE_LINE);
                e.gc.drawLine(0, FlatFeatureDialogSelectedFeaturePage.this.titleHeight + FlatFeatureDialogSelectedFeaturePage.this.line, FlatFeatureDialogSelectedFeaturePage.this.width, FlatFeatureDialogSelectedFeaturePage.this.titleHeight + FlatFeatureDialogSelectedFeaturePage.this.line);
            }
        });
        this.selecetedScrolledComp = new ScrolledComposite(this.selectedComp, 512);
        this.selecetedScrolledComp.setLayout((Layout)new FormLayout());
        data = new FormData();
        data.top = new FormAttachment(0, this.bodyTop);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, VSCROLL_MARGIN);
        data.bottom = new FormAttachment(100, 0);
        this.selecetedScrolledComp.setLayoutData((Object)data);
        this.selecetedScrolledComp.setExpandHorizontal(true);
        this.selecetedScrolledComp.setExpandVertical(true);
        this.selecetedScrolledComp.setBackground(ColorResources.FEATURE_FEATURELISTCOMP_NORMAL_BACKGROUND);
        this.selecetedScrolledComp.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(ColorResources.FEATURE_FEATURELISTCOMP_LINE);
                e.gc.drawLine(0, 0, FlatFeatureDialogSelectedFeaturePage.this.width, 0);
            }
        });
        this.selectedInputComp = new Composite((Composite)this.selecetedScrolledComp, 0);
        this.selecetedScrolledComp.setContent((Control)this.selectedInputComp);
        this.selecetedScrolledComp.setMinSize(this.selectedInputComp.computeSize(-1, -1));
        this.selecetedScrolledComp.setShowFocusedControl(true);
        this.selectedInputComp.setLayout((Layout)new FormLayout());
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, VSCROLL_MARGIN);
        data.bottom = new FormAttachment(100, 0);
        this.selectedInputComp.setLayoutData((Object)data);
        this.selectedInputComp.setBackground(ColorResources.FEATURE_FEATURELISTCOMP_NORMAL_BACKGROUND);
        this.selectedInputComp.addListener(6, new Listener(){

            public void handleEvent(Event event) {
                FlatFeatureDialogSelectedFeaturePage.this.selectedInputComp.setFocus();
            }
        });
        TargetData target = SettingDataManager.INSTANCE.getTarget(null);
        Logger.debug(target.getSelectedFlatFeatures());
        if (target.getSelectedFlatFeatures().size() > 0) {
            this.featureDialog.getOKButton().setEnabled(true);
        } else {
            this.featureDialog.getOKButton().setEnabled(false);
            this.noItemLabel = new Label(this.selectedInputComp, 0x40000000);
            data = new FormData();
            data.top = new FormAttachment(0, this.noItemUpperMargin);
            data.left = new FormAttachment(0, this.noItemTopMargin);
            data.width = this.width - this.noItemTopMargin;
            data.height = this.titleHeight;
            this.noItemLabel.setLayoutData((Object)data);
            this.noItemLabel.setText(ConfigureLabels.SETTING_DIALOG_NO_ITEM_SELECTED);
            this.noItemLabel.setBackground(ColorResources.FEATURE_FEATURELISTCOMP_NORMAL_BACKGROUND);
            this.noItemLabel.setForeground(ColorResources.GRAY_130);
            this.noItemLabel.setFont(FontResources.SETTING_TITLE_FONT);
        }
        int topPosition = BODY_TOP_MARGIN;
        int leftPosition = ITEM_LEFT;
        for (FlatFeature feature : target.getSelectedFlatFeatures()) {
            this.selectedIcon = new Label(this.selectedInputComp, 0x40000000);
            this.selectedIcon.setImage(feature.getSmallImage());
            data = new FormData();
            data.top = new FormAttachment(0, topPosition);
            data.left = new FormAttachment(0, leftPosition);
            data.width = ICON_SIZE;
            data.height = ICON_SIZE;
            this.selectedIcon.setLayoutData((Object)data);
            this.selectedIcon.setBackground(ColorResources.FEATURE_FEATURELISTCOMP_NORMAL_BACKGROUND);
            this.selectedNameLabel = new Label(this.selectedInputComp, 0x40000000);
            data = new FormData();
            data.top = new FormAttachment(0, topPosition + ITEM_TITLE_TOP);
            data.left = new FormAttachment(0, ITEM_TITLE_LEFT);
            data.width = ITEM_TITLE_WIDTH;
            data.height = TITLE_FONT_SIZE;
            this.selectedNameLabel.setLayoutData((Object)data);
            this.selectedNameLabel.setText(feature.getName());
            this.selectedNameLabel.setBackground(ColorResources.FEATURE_FEATURELISTCOMP_NORMAL_BACKGROUND);
            this.selectedNameLabel.setForeground(ColorResources.DEFAULT_FONT_COLOR);
            this.selectedNameLabel.setFont(FontResources.SETTING_TITLE_FONT);
            Point delImagePoint = new Point(0, 0);
            this.delToggle = this.createToggleButton(this.selectedInputComp, ImageResources.DELETE, delImagePoint, feature.getName(), null, BUTTON_SIZE, BUTTON_SIZE, topPosition + BUTTON_TOP, this.width - BUTTON_SIZE + BUTTON_RIGHT);
            this.delToggle.addListener(4, this.deleteClickListener);
            this.delToggle.addListener(6, this.cursorListener);
            this.delToggle.addListener(7, this.cursorListener);
            if (feature.isConfigurable()) {
                DACustomButton confToggle = new DACustomButton(this.selectedInputComp, ImageResources.CONFIG_FEATURE_NORMAL, ImageResources.CONFIG_FEATURE_PUSH, ImageResources.CONFIG_FEATURE_HOVER, ImageResources.CONFIG_FEATURE_NORMAL);
                confToggle.setBackground(ColorResources.FEATURE_FEATURELISTCOMP_NORMAL_BACKGROUND);
                confToggle.setButtonImagePoint(new Point(0, 0));
                confToggle.setData((Object)feature.getName());
                data = new FormData(BUTTON_SIZE, BUTTON_SIZE);
                data.right = new FormAttachment((Control)this.delToggle, BUTTON_SPACING);
                data.top = new FormAttachment(0, topPosition + BUTTON_TOP);
                confToggle.setLayoutData((Object)data);
                confToggle.addListener(4, this.configClickListener);
                confToggle.addListener(6, this.cursorListener);
                confToggle.addListener(7, this.cursorListener);
            }
            topPosition += ICON_SIZE + ITEM_DIST;
        }
        this.selectedComp.layout(true);
        this.selectedInputComp.layout();
        this.selecetedScrolledComp.setMinSize(this.selectedInputComp.computeSize(-1, -1));
        this.selecetedScrolledComp.getVerticalBar().setIncrement(ICON_SIZE / 2);
        this.selecetedScrolledComp.getVerticalBar().setPageIncrement(ICON_SIZE * 2);
        if (!DAState.isStartable()) {
            this.selectedComp.setEnabled(false);
        }
    }
}

