/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.tizen.dynamicanalyzer.common.path.PathManager;
import org.tizen.dynamicanalyzer.util.CommonUtil;

public class InternalLogManager {
    private static InternalLogManager instance;
    public static final int LOG_TYPE_HOST = 0;
    public static final int LOG_TYPE_TARGET = 1;
    public static final int LOG_TYPE_ERROR = 2;
    public static final int LOG_TYPE_WARNING = 3;
    public static final int LOG_TYPE_INFO = 4;
    public static final int LOG_TYPE_FUNCTION = 5;
    public static final int LOG_TYPE_USAGE = 6;
    public static final int AUTO_TEST_COUNT = 20;
    private Date hostStartTime;
    private long hostStart;
    private long logLevel;
    private HashMap<String, List<Long>> usageTime;
    private HashMap<String, Long> usageCount;
    private HashMap<String, Long> usageTotalCount;
    private HashMap<String, Long> usageTotalTime;
    private SimpleDateFormat dateFormat;
    File outputFile;
    FileWriter fileWriter = null;
    BufferedWriter buffWriter = null;
    PrintWriter printWriter = null;

    private InternalLogManager() {
        this.init();
    }

    public static InternalLogManager getInstance() {
        if (instance == null) {
            instance = new InternalLogManager();
        }
        return instance;
    }

    private boolean checkLevel(int type) {
        return this.logLevel >= (long)type;
    }

    private void init() {
        this.dateFormat = new SimpleDateFormat("yyyy:MM:dd:HH:mm:ss:SSS");
        if (this.checkLevel(5)) {
            this.usageTime = new HashMap();
            this.usageCount = new HashMap();
            this.usageTotalCount = new HashMap();
            this.usageTotalTime = new HashMap();
        }
    }

    public Date getHostStartTime() {
        return this.hostStartTime;
    }

    public void log(String msg) {
        if (this.checkLevel(4)) {
            this.log(4, msg);
        }
    }

    public void log(int type, String msg) {
        Date time = Calendar.getInstance().getTime();
        this.printLog(type, time, msg);
        if (2 == type) {
            new UnsupportedOperationException().printStackTrace();
        }
    }

    public void logHostStart() {
        if (this.checkLevel(0)) {
            this.hostStartTime = Calendar.getInstance().getTime();
            this.hostStart = this.hostStartTime.getTime();
            this.printLog(0, this.hostStartTime, "START");
        }
    }

    public void logHostEnd() {
        if (this.checkLevel(0)) {
            this.log(0, "END");
        }
    }

    public void startFunction() {
        if (this.checkLevel(5)) {
            StackTraceElement[] stackTraceEelement = Thread.currentThread().getStackTrace();
            StringBuilder key = new StringBuilder();
            key.append(stackTraceEelement[2].getClassName());
            key.append(".");
            key.append(stackTraceEelement[2].getMethodName());
            this.start(5, key.toString());
        }
    }

    public void endFunction() {
        if (this.checkLevel(5)) {
            StackTraceElement[] stackTraceEelement = Thread.currentThread().getStackTrace();
            StringBuilder key = new StringBuilder();
            key.append(stackTraceEelement[2].getClassName());
            key.append(".");
            key.append(stackTraceEelement[2].getMethodName());
            this.end(5, key.toString());
        }
    }

    public void start(String key) {
        if (this.checkLevel(6)) {
            this.start(6, key);
        }
    }

    public void end(String key) {
        if (this.checkLevel(6)) {
            this.end(6, key);
        }
    }

    public void point(String key, String msg) {
        if (this.checkLevel(6)) {
            this.point(6, key, msg);
        }
    }

    public void autoTestStart(String key) {
        if (this.checkLevel(6)) {
            this.autoTestStart(6, key);
        }
    }

    public void autoTestEnd(String key) {
        if (this.checkLevel(6)) {
            this.autoTestEnd(6, key);
        }
    }

    public void autoTest(String key, String className, String name) {
        if (this.checkLevel(6)) {
            Date time = Calendar.getInstance().getTime();
            long nanoTime = System.nanoTime();
            Long count = this.usageCount.get(key);
            if (count == null || 0L == count) {
                this.printLog(6, time, "can't find start|" + key + "|autoTest");
            } else {
                List<Long> startTimes = this.usageTime.get(key);
                long startTime = startTimes.remove(startTimes.size() - 1);
                long spendTime = nanoTime - startTime;
                long totalCount = this.usageTotalCount.get(key) + 1L;
                long totalTime = this.usageTotalTime.get(key) + spendTime;
                startTimes.add(nanoTime);
                this.usageTotalCount.put(key, totalCount);
                this.usageTotalTime.put(key, totalTime);
                StringBuilder msg = new StringBuilder();
                msg.append("<testcase classname=\"");
                msg.append(className);
                msg.append("\" name=\"");
                msg.append(name);
                msg.append("\" time=\"");
                msg.append(String.format("%.3f", (double)spendTime / 1.0E9));
                msg.append("\"/>\n");
                this.printOutput(msg);
            }
        }
    }

    public long getAutoTestCount(String key) {
        System.out.println("count : " + this.usageTotalCount.get(key));
        return this.usageTotalCount.get(key);
    }

    private void start(int logType, String key) {
        if (this.checkLevel(logType)) {
            List<Object> startTimes;
            Long count = this.usageCount.get(key);
            if (count == null) {
                count = 1L;
                this.usageCount.put(key, count);
                startTimes = new ArrayList();
                this.usageTime.put(key, startTimes);
                this.usageTotalCount.put(key, 0L);
                this.usageTotalTime.put(key, 0L);
            } else {
                this.usageCount.put(key, count + 1L);
                startTimes = this.usageTime.get(key);
            }
            long nanoTime = System.nanoTime();
            Date time = Calendar.getInstance().getTime();
            startTimes.add(nanoTime);
            this.printLog(logType, time, String.valueOf(key) + "|start");
        }
    }

    private void end(int logType, String key) {
        if (this.checkLevel(logType)) {
            Date time = Calendar.getInstance().getTime();
            long nanoTime = System.nanoTime();
            Long count = this.usageCount.get(key);
            if (count == null || 0L == count) {
                this.printLog(logType, time, "can't find start|" + key + "|end");
            } else {
                List<Long> startTimes = this.usageTime.get(key);
                long startTime = startTimes.remove(startTimes.size() - 1);
                long spendTime = nanoTime - startTime;
                long totalCount = this.usageTotalCount.get(key) + 1L;
                long totalTime = this.usageTotalTime.get(key) + spendTime;
                this.usageCount.put(key, count - 1L);
                this.usageTotalCount.put(key, totalCount);
                this.usageTotalTime.put(key, totalTime);
                StringBuilder msg = new StringBuilder();
                msg.append("count:");
                msg.append(totalCount);
                msg.append("|spend:");
                msg.append(spendTime);
                msg.append("(ns)|total:");
                msg.append(totalTime);
                msg.append("(ns)|");
                msg.append(key);
                msg.append("|end");
                this.printLog(logType, time, msg);
            }
        }
    }

    private void autoTestStart(int logType, String key) {
        if (this.checkLevel(logType)) {
            List<Object> startTimes;
            Long count = this.usageCount.get(key);
            if (count == null) {
                count = 1L;
                this.usageCount.put(key, count);
                startTimes = new ArrayList();
                this.usageTime.put(key, startTimes);
                this.usageTotalCount.put(key, 0L);
                this.usageTotalTime.put(key, 0L);
            } else {
                this.usageCount.put(key, count + 1L);
                startTimes = this.usageTime.get(key);
            }
            long nanoTime = System.nanoTime();
            startTimes.add(nanoTime);
            if (this.printWriter == null) {
                this.openWriter();
            }
            StringBuilder msg = new StringBuilder();
            msg.append("<testsuite tests=\"");
            msg.append(20);
            msg.append("\">");
            this.printOutput(msg);
        }
    }

    private void autoTestEnd(int logType, String key) {
        if (this.checkLevel(logType)) {
            Date time = Calendar.getInstance().getTime();
            long nanoTime = System.nanoTime();
            Long count = this.usageCount.get(key);
            if (count == null || 0L == count) {
                this.printLog(logType, time, "can't find start|" + key + "|end");
            } else {
                List<Long> startTimes = this.usageTime.get(key);
                long startTime = startTimes.remove(startTimes.size() - 1);
                long spendTime = nanoTime - startTime;
                long totalCount = this.usageTotalCount.get(key) + 1L;
                long totalTime = this.usageTotalTime.get(key) + spendTime;
                this.usageCount.put(key, count - 1L);
                this.usageTotalCount.put(key, totalCount);
                this.usageTotalTime.put(key, totalTime);
                StringBuilder msg = new StringBuilder();
                msg.append("</testsuite>");
                this.printOutput(msg);
                this.closeWriter();
            }
        }
    }

    private void point(int logType, String key, String msg) {
        if (this.checkLevel(logType)) {
            Date time = Calendar.getInstance().getTime();
            long nanoTime = System.nanoTime();
            Long count = this.usageCount.get(key);
            if (count == null || 0L == count) {
                this.printLog(logType, time, "can't find start|" + key + "|end");
            } else {
                List<Long> startTimes = this.usageTime.get(key);
                long startTime = startTimes.remove(startTimes.size() - 1);
                long spendTime = nanoTime - startTime;
                long totalCount = this.usageTotalCount.get(key) + 1L;
                long totalTime = this.usageTotalTime.get(key) + spendTime;
                startTimes.add(nanoTime);
                this.usageTotalCount.put(key, totalCount);
                this.usageTotalTime.put(key, totalTime);
                StringBuilder msgs = new StringBuilder();
                msgs.append("count:");
                msgs.append(totalCount);
                msgs.append("|spend:");
                msgs.append(spendTime);
                msgs.append("(ns)|total:");
                msgs.append(totalTime);
                msgs.append("(ns)|");
                msgs.append(key);
                msgs.append(msg);
                msgs.append(":");
                msgs.append("|point");
                this.printLog(logType, time, msgs);
            }
        }
    }

    public boolean isStart(int logType, String key) {
        if (this.checkLevel(logType)) {
            return this.usageTime.containsKey(key);
        }
        return false;
    }

    public boolean isStart(String key) {
        if (this.checkLevel(6)) {
            return this.isStart(6, key);
        }
        return false;
    }

    private void printLog(int logType, Date time, CharSequence msg) {
        if (time == null) {
            return;
        }
        long spendTime = time.getTime() - this.hostStart;
        switch (logType) {
            case 4: {
                System.out.print("||INFO||");
                break;
            }
            case 3: {
                System.out.print("||WARNING||");
                break;
            }
            case 2: {
                System.out.print("||ERROR||");
                break;
            }
            case 0: {
                System.out.print("||HOST||");
                break;
            }
            case 1: {
                System.out.print("||TARGET||");
                break;
            }
            case 5: {
                System.out.print("||FUNCTION||");
                break;
            }
            case 6: {
                System.out.print("||USAGE||");
                break;
            }
            default: {
                System.out.print("||UNKNOWNTYPE||");
            }
        }
        System.out.println(String.valueOf(this.dateFormat.format(time)) + "||" + spendTime + "||" + msg);
    }

    public void printOutput(CharSequence msg) {
        if (this.printWriter == null) {
            return;
        }
        this.printWriter.println(msg);
        this.printWriter.checkError();
    }

    private void openWriter() {
        File autotestPath = new File(PathManager.DA_AUTOTEST_PATH);
        if (!autotestPath.exists() && !autotestPath.mkdirs()) {
            System.out.println("auto test path file create failed...");
            return;
        }
        StringBuilder savePath = new StringBuilder();
        savePath.append(PathManager.DA_AUTOTEST_PATH);
        savePath.append(File.separator);
        savePath.append("DA_Autotest_Result.xsd");
        this.outputFile = new File(savePath.toString());
        try {
            this.fileWriter = new FileWriter(this.outputFile);
            this.buffWriter = new BufferedWriter(this.fileWriter);
            this.printWriter = new PrintWriter(this.buffWriter);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void closeWriter() {
        CommonUtil.tryClose((Object[])new Object[]{this.outputFile, this.fileWriter, this.buffWriter, this.printWriter});
        this.outputFile = null;
        this.fileWriter = null;
        this.buffWriter = null;
        this.printWriter = null;
    }

    public void clear() {
    }
}

